package zio.aws.codeartifact.model
import zio.aws.codeartifact.model.primitives.{
  AccountId,
  ListRepositoriesInDomainMaxResults,
  DomainName,
  RepositoryName,
  PaginationToken
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRepositoriesInDomainRequest(
    domain: DomainName,
    domainOwner: Optional[AccountId] = Optional.Absent,
    administratorAccount: Optional[AccountId] = Optional.Absent,
    repositoryPrefix: Optional[RepositoryName] = Optional.Absent,
    maxResults: Optional[ListRepositoriesInDomainMaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest = {
    import ListRepositoriesInDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .optionallyWith(
        administratorAccount.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.administratorAccount)
      .optionallyWith(
        repositoryPrefix.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryPrefix)
      .optionallyWith(
        maxResults.map(value =>
          ListRepositoriesInDomainMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListRepositoriesInDomainRequest.ReadOnly =
    zio.aws.codeartifact.model.ListRepositoriesInDomainRequest
      .wrap(buildAwsValue())
}
object ListRepositoriesInDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListRepositoriesInDomainRequest =
      zio.aws.codeartifact.model.ListRepositoriesInDomainRequest(
        domain,
        domainOwner.map(value => value),
        administratorAccount.map(value => value),
        repositoryPrefix.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Optional[AccountId]
    def administratorAccount: Optional[AccountId]
    def repositoryPrefix: Optional[RepositoryName]
    def maxResults: Optional[ListRepositoriesInDomainMaxResults]
    def nextToken: Optional[PaginationToken]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getAdministratorAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("administratorAccount", administratorAccount)
    def getRepositoryPrefix: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryPrefix", repositoryPrefix)
    def getMaxResults: ZIO[Any, AwsError, ListRepositoriesInDomainMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest
  ) extends zio.aws.codeartifact.model.ListRepositoriesInDomainRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val administratorAccount: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.administratorAccount())
        .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repositoryPrefix: Optional[RepositoryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryPrefix())
        .map(value =>
          zio.aws.codeartifact.model.primitives.RepositoryName(value)
        )
    override val maxResults: Optional[ListRepositoriesInDomainMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codeartifact.model.primitives
            .ListRepositoriesInDomainMaxResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest
  ): zio.aws.codeartifact.model.ListRepositoriesInDomainRequest.ReadOnly =
    new Wrapper(impl)
}
