package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  AccountId,
  DomainName,
  RepositoryName,
  PackageVersion,
  PaginationToken,
  PackageNamespace
}
import scala.jdk.CollectionConverters._
final case class ListPackageVersionDependenciesRequest(
    domain: DomainName,
    domainOwner: Optional[AccountId] = Optional.Absent,
    repository: RepositoryName,
    format: zio.aws.codeartifact.model.PackageFormat,
    namespace: Optional[PackageNamespace] = Optional.Absent,
    packageValue: PackageName,
    packageVersion: PackageVersion,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesRequest = {
    import ListPackageVersionDependenciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .format(format.unwrap)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .packageValue(PackageName.unwrap(packageValue): java.lang.String)
      .packageVersion(PackageVersion.unwrap(packageVersion): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListPackageVersionDependenciesRequest.ReadOnly =
    zio.aws.codeartifact.model.ListPackageVersionDependenciesRequest
      .wrap(buildAwsValue())
}
object ListPackageVersionDependenciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.ListPackageVersionDependenciesRequest =
      zio.aws.codeartifact.model.ListPackageVersionDependenciesRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        format,
        namespace.map(value => value),
        packageValue,
        packageVersion,
        nextToken.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Optional[AccountId]
    def repository: RepositoryName
    def format: zio.aws.codeartifact.model.PackageFormat
    def namespace: Optional[PackageNamespace]
    def packageValue: PackageName
    def packageVersion: PackageVersion
    def nextToken: Optional[PaginationToken]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getFormat: ZIO[Any, Nothing, zio.aws.codeartifact.model.PackageFormat] =
      ZIO.succeed(format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, Nothing, PackageName] =
      ZIO.succeed(packageValue)
    def getPackageVersion: ZIO[Any, Nothing, PackageVersion] =
      ZIO.succeed(packageVersion)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesRequest
  ) extends zio.aws.codeartifact.model.ListPackageVersionDependenciesRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val format: zio.aws.codeartifact.model.PackageFormat =
      zio.aws.codeartifact.model.PackageFormat.wrap(impl.format())
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: PackageName =
      zio.aws.codeartifact.model.primitives.PackageName(impl.packageValue())
    override val packageVersion: PackageVersion =
      zio.aws.codeartifact.model.primitives
        .PackageVersion(impl.packageVersion())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesRequest
  ): zio.aws.codeartifact.model.ListPackageVersionDependenciesRequest.ReadOnly =
    new Wrapper(impl)
}
