package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PolicyDocument,
  PolicyRevision,
  Arn
}
import scala.jdk.CollectionConverters._
final case class ResourcePolicy(
    resourceArn: Optional[Arn] = Optional.Absent,
    revision: Optional[PolicyRevision] = Optional.Absent,
    document: Optional[PolicyDocument] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ResourcePolicy = {
    import ResourcePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ResourcePolicy
      .builder()
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        revision.map(value => PolicyRevision.unwrap(value): java.lang.String)
      )(_.revision)
      .optionallyWith(
        document.map(value => PolicyDocument.unwrap(value): java.lang.String)
      )(_.document)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.ResourcePolicy.ReadOnly =
    zio.aws.codeartifact.model.ResourcePolicy.wrap(buildAwsValue())
}
object ResourcePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ResourcePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ResourcePolicy =
      zio.aws.codeartifact.model.ResourcePolicy(
        resourceArn.map(value => value),
        revision.map(value => value),
        document.map(value => value)
      )
    def resourceArn: Optional[Arn]
    def revision: Optional[PolicyRevision]
    def document: Optional[PolicyDocument]
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getRevision: ZIO[Any, AwsError, PolicyRevision] =
      AwsError.unwrapOptionField("revision", revision)
    def getDocument: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("document", document)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ResourcePolicy
  ) extends zio.aws.codeartifact.model.ResourcePolicy.ReadOnly {
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.codeartifact.model.primitives.Arn(value))
    override val revision: Optional[PolicyRevision] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => zio.aws.codeartifact.model.primitives.PolicyRevision(value))
    override val document: Optional[PolicyDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.document())
      .map(value => zio.aws.codeartifact.model.primitives.PolicyDocument(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ResourcePolicy
  ): zio.aws.codeartifact.model.ResourcePolicy.ReadOnly = new Wrapper(impl)
}
