package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PackageOriginRestrictions(
    publish: zio.aws.codeartifact.model.AllowPublish,
    upstream: zio.aws.codeartifact.model.AllowUpstream
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PackageOriginRestrictions = {
    import PackageOriginRestrictions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PackageOriginRestrictions
      .builder()
      .publish(publish.unwrap)
      .upstream(upstream.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.PackageOriginRestrictions.ReadOnly =
    zio.aws.codeartifact.model.PackageOriginRestrictions.wrap(buildAwsValue())
}
object PackageOriginRestrictions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PackageOriginRestrictions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PackageOriginRestrictions =
      zio.aws.codeartifact.model.PackageOriginRestrictions(publish, upstream)
    def publish: zio.aws.codeartifact.model.AllowPublish
    def upstream: zio.aws.codeartifact.model.AllowUpstream
    def getPublish: ZIO[Any, Nothing, zio.aws.codeartifact.model.AllowPublish] =
      ZIO.succeed(publish)
    def getUpstream
        : ZIO[Any, Nothing, zio.aws.codeartifact.model.AllowUpstream] =
      ZIO.succeed(upstream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageOriginRestrictions
  ) extends zio.aws.codeartifact.model.PackageOriginRestrictions.ReadOnly {
    override val publish: zio.aws.codeartifact.model.AllowPublish =
      zio.aws.codeartifact.model.AllowPublish.wrap(impl.publish())
    override val upstream: zio.aws.codeartifact.model.AllowUpstream =
      zio.aws.codeartifact.model.AllowUpstream.wrap(impl.upstream())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageOriginRestrictions
  ): zio.aws.codeartifact.model.PackageOriginRestrictions.ReadOnly =
    new Wrapper(impl)
}
