package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeartifact.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Iterable[zio.aws.codeartifact.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.TagResourceRequest.ReadOnly =
    zio.aws.codeartifact.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.TagResourceRequest =
      zio.aws.codeartifact.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: Arn
    def tags: List[zio.aws.codeartifact.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.codeartifact.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.TagResourceRequest
  ) extends zio.aws.codeartifact.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.codeartifact.model.primitives.Arn(impl.resourceArn())
    override val tags: List[zio.aws.codeartifact.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.codeartifact.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.TagResourceRequest
  ): zio.aws.codeartifact.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
