package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeartifact.model.primitives.RepositoryName
import scala.jdk.CollectionConverters._
final case class UpstreamRepository(repositoryName: RepositoryName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.UpstreamRepository = {
    import UpstreamRepository.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.UpstreamRepository
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.UpstreamRepository.ReadOnly =
    zio.aws.codeartifact.model.UpstreamRepository.wrap(buildAwsValue())
}
object UpstreamRepository {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.UpstreamRepository
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.UpstreamRepository =
      zio.aws.codeartifact.model.UpstreamRepository(repositoryName)
    def repositoryName: RepositoryName
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.UpstreamRepository
  ) extends zio.aws.codeartifact.model.UpstreamRepository.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codeartifact.model.primitives
        .RepositoryName(impl.repositoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.UpstreamRepository
  ): zio.aws.codeartifact.model.UpstreamRepository.ReadOnly = new Wrapper(impl)
}
