package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutPackageOriginConfigurationResponse(
    originConfiguration: Optional[
      zio.aws.codeartifact.model.PackageOriginConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PutPackageOriginConfigurationResponse = {
    import PutPackageOriginConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PutPackageOriginConfigurationResponse
      .builder()
      .optionallyWith(originConfiguration.map(value => value.buildAwsValue()))(
        _.originConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.PutPackageOriginConfigurationResponse.ReadOnly =
    zio.aws.codeartifact.model.PutPackageOriginConfigurationResponse
      .wrap(buildAwsValue())
}
object PutPackageOriginConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PutPackageOriginConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.PutPackageOriginConfigurationResponse =
      zio.aws.codeartifact.model.PutPackageOriginConfigurationResponse(
        originConfiguration.map(value => value.asEditable)
      )
    def originConfiguration: Optional[
      zio.aws.codeartifact.model.PackageOriginConfiguration.ReadOnly
    ]
    def getOriginConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.PackageOriginConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("originConfiguration", originConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PutPackageOriginConfigurationResponse
  ) extends zio.aws.codeartifact.model.PutPackageOriginConfigurationResponse.ReadOnly {
    override val originConfiguration: Optional[
      zio.aws.codeartifact.model.PackageOriginConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.originConfiguration())
      .map(value =>
        zio.aws.codeartifact.model.PackageOriginConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PutPackageOriginConfigurationResponse
  ): zio.aws.codeartifact.model.PutPackageOriginConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
