package zio.aws.codeartifact.model
import zio.aws.codeartifact.model.primitives.{
  Timestamp,
  Arn,
  AccountId,
  DomainName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DomainSummary(
    name: Optional[DomainName] = Optional.Absent,
    owner: Optional[AccountId] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.codeartifact.model.DomainStatus] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    encryptionKey: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DomainSummary = {
    import DomainSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DomainSummary
      .builder()
      .optionallyWith(
        name.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        owner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        encryptionKey.map(value => Arn.unwrap(value): java.lang.String)
      )(_.encryptionKey)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.DomainSummary.ReadOnly =
    zio.aws.codeartifact.model.DomainSummary.wrap(buildAwsValue())
}
object DomainSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DomainSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DomainSummary =
      zio.aws.codeartifact.model.DomainSummary(
        name.map(value => value),
        owner.map(value => value),
        arn.map(value => value),
        status.map(value => value),
        createdTime.map(value => value),
        encryptionKey.map(value => value)
      )
    def name: Optional[DomainName]
    def owner: Optional[AccountId]
    def arn: Optional[Arn]
    def status: Optional[zio.aws.codeartifact.model.DomainStatus]
    def createdTime: Optional[Timestamp]
    def encryptionKey: Optional[Arn]
    def getName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("owner", owner)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus: ZIO[Any, AwsError, zio.aws.codeartifact.model.DomainStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getEncryptionKey: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DomainSummary
  ) extends zio.aws.codeartifact.model.DomainSummary.ReadOnly {
    override val name: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codeartifact.model.primitives.DomainName(value))
    override val owner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.codeartifact.model.primitives.Arn(value))
    override val status: Optional[zio.aws.codeartifact.model.DomainStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codeartifact.model.DomainStatus.wrap(value))
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.codeartifact.model.primitives.Timestamp(value))
    override val encryptionKey: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => zio.aws.codeartifact.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DomainSummary
  ): zio.aws.codeartifact.model.DomainSummary.ReadOnly = new Wrapper(impl)
}
