package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.PackageVersion
import scala.jdk.CollectionConverters._
final case class DisposePackageVersionsResponse(
    successfulVersions: Optional[Map[
      PackageVersion,
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo
    ]] = Optional.Absent,
    failedVersions: Optional[
      Map[PackageVersion, zio.aws.codeartifact.model.PackageVersionError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DisposePackageVersionsResponse = {
    import DisposePackageVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DisposePackageVersionsResponse
      .builder()
      .optionallyWith(
        successfulVersions.map(value =>
          value
            .map({ case (key, value) =>
              (PackageVersion.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.successfulVersions)
      .optionallyWith(
        failedVersions.map(value =>
          value
            .map({ case (key, value) =>
              (PackageVersion.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.failedVersions)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.DisposePackageVersionsResponse.ReadOnly =
    zio.aws.codeartifact.model.DisposePackageVersionsResponse
      .wrap(buildAwsValue())
}
object DisposePackageVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DisposePackageVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DisposePackageVersionsResponse =
      zio.aws.codeartifact.model.DisposePackageVersionsResponse(
        successfulVersions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        failedVersions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def successfulVersions: Optional[Map[
      PackageVersion,
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly
    ]]
    def failedVersions: Optional[Map[
      PackageVersion,
      zio.aws.codeartifact.model.PackageVersionError.ReadOnly
    ]]
    def getSuccessfulVersions: ZIO[Any, AwsError, Map[
      PackageVersion,
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("successfulVersions", successfulVersions)
    def getFailedVersions: ZIO[Any, AwsError, Map[
      PackageVersion,
      zio.aws.codeartifact.model.PackageVersionError.ReadOnly
    ]] = AwsError.unwrapOptionField("failedVersions", failedVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DisposePackageVersionsResponse
  ) extends zio.aws.codeartifact.model.DisposePackageVersionsResponse.ReadOnly {
    override val successfulVersions: Optional[Map[
      PackageVersion,
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.successfulVersions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codeartifact.model.primitives.PackageVersion(
              key
            ) -> zio.aws.codeartifact.model.SuccessfulPackageVersionInfo
              .wrap(value)
          })
          .toMap
      )
    override val failedVersions: Optional[Map[
      PackageVersion,
      zio.aws.codeartifact.model.PackageVersionError.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.failedVersions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codeartifact.model.primitives.PackageVersion(
              key
            ) -> zio.aws.codeartifact.model.PackageVersionError.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DisposePackageVersionsResponse
  ): zio.aws.codeartifact.model.DisposePackageVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
