package zio.aws.codeartifact
import zio.aws.codeartifact.model.CreateDomainResponse.ReadOnly
import software.amazon.awssdk.services.codeartifact.CodeartifactAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.codeartifact.model.{
  GetAuthorizationTokenRequest,
  DisposePackageVersionsRequest,
  AssociateExternalConnectionRequest,
  ListPackagesRequest,
  ListPackageVersionAssetsRequest,
  ListRepositoriesInDomainRequest,
  GetRepositoryEndpointRequest,
  ListTagsForResourceRequest,
  CreateRepositoryRequest,
  DeleteDomainRequest,
  DeleteRepositoryPermissionsPolicyRequest,
  CopyPackageVersionsRequest,
  GetPackageVersionReadmeRequest,
  DeletePackageVersionsRequest,
  DescribePackageVersionRequest,
  DescribeDomainRequest,
  CreateDomainRequest,
  UntagResourceRequest,
  ListRepositoriesRequest,
  ListPackageVersionsRequest,
  DescribeRepositoryRequest,
  DisassociateExternalConnectionRequest,
  PutDomainPermissionsPolicyRequest,
  DeleteDomainPermissionsPolicyRequest,
  ListPackageVersionDependenciesRequest,
  DeleteRepositoryRequest,
  PutRepositoryPermissionsPolicyRequest,
  GetDomainPermissionsPolicyRequest,
  UpdatePackageVersionsStatusRequest,
  UpdateRepositoryRequest,
  ListDomainsRequest,
  TagResourceRequest,
  GetRepositoryPermissionsPolicyRequest,
  GetPackageVersionAssetRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object CodeartifactMock extends Mock[Codeartifact] {
  object GetAuthorizationToken
      extends Effect[
        GetAuthorizationTokenRequest,
        AwsError,
        zio.aws.codeartifact.model.GetAuthorizationTokenResponse.ReadOnly
      ]
  object ListPackageVersionDependencies
      extends Effect[
        ListPackageVersionDependenciesRequest,
        AwsError,
        zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse.ReadOnly
      ]
  object GetPackageVersionAsset
      extends Effect[
        GetPackageVersionAssetRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.codeartifact.model.GetPackageVersionAssetResponse.ReadOnly,
          Byte
        ]
      ]
  object DescribeDomain
      extends Effect[
        DescribeDomainRequest,
        AwsError,
        zio.aws.codeartifact.model.DescribeDomainResponse.ReadOnly
      ]
  object DeletePackageVersions
      extends Effect[
        DeletePackageVersionsRequest,
        AwsError,
        zio.aws.codeartifact.model.DeletePackageVersionsResponse.ReadOnly
      ]
  object GetRepositoryEndpoint
      extends Effect[
        GetRepositoryEndpointRequest,
        AwsError,
        zio.aws.codeartifact.model.GetRepositoryEndpointResponse.ReadOnly
      ]
  object DeleteRepository
      extends Effect[
        DeleteRepositoryRequest,
        AwsError,
        zio.aws.codeartifact.model.DeleteRepositoryResponse.ReadOnly
      ]
  object ListPackageVersionAssets
      extends Stream[
        ListPackageVersionAssetsRequest,
        AwsError,
        zio.aws.codeartifact.model.AssetSummary.ReadOnly
      ]
  object ListPackageVersionAssetsPaginated
      extends Effect[
        ListPackageVersionAssetsRequest,
        AwsError,
        zio.aws.codeartifact.model.ListPackageVersionAssetsResponse.ReadOnly
      ]
  object ListDomains
      extends Stream[
        ListDomainsRequest,
        AwsError,
        zio.aws.codeartifact.model.DomainSummary.ReadOnly
      ]
  object ListDomainsPaginated
      extends Effect[
        ListDomainsRequest,
        AwsError,
        zio.aws.codeartifact.model.ListDomainsResponse.ReadOnly
      ]
  object DisassociateExternalConnection
      extends Effect[
        DisassociateExternalConnectionRequest,
        AwsError,
        zio.aws.codeartifact.model.DisassociateExternalConnectionResponse.ReadOnly
      ]
  object UpdatePackageVersionsStatus
      extends Effect[
        UpdatePackageVersionsStatusRequest,
        AwsError,
        zio.aws.codeartifact.model.UpdatePackageVersionsStatusResponse.ReadOnly
      ]
  object AssociateExternalConnection
      extends Effect[
        AssociateExternalConnectionRequest,
        AwsError,
        zio.aws.codeartifact.model.AssociateExternalConnectionResponse.ReadOnly
      ]
  object UpdateRepository
      extends Effect[
        UpdateRepositoryRequest,
        AwsError,
        zio.aws.codeartifact.model.UpdateRepositoryResponse.ReadOnly
      ]
  object CreateRepository
      extends Effect[
        CreateRepositoryRequest,
        AwsError,
        zio.aws.codeartifact.model.CreateRepositoryResponse.ReadOnly
      ]
  object DeleteRepositoryPermissionsPolicy
      extends Effect[
        DeleteRepositoryPermissionsPolicyRequest,
        AwsError,
        zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse.ReadOnly
      ]
  object GetPackageVersionReadme
      extends Effect[
        GetPackageVersionReadmeRequest,
        AwsError,
        zio.aws.codeartifact.model.GetPackageVersionReadmeResponse.ReadOnly
      ]
  object CreateDomain extends Effect[CreateDomainRequest, AwsError, ReadOnly]
  object DescribeRepository
      extends Effect[
        DescribeRepositoryRequest,
        AwsError,
        zio.aws.codeartifact.model.DescribeRepositoryResponse.ReadOnly
      ]
  object GetDomainPermissionsPolicy
      extends Effect[
        GetDomainPermissionsPolicyRequest,
        AwsError,
        zio.aws.codeartifact.model.GetDomainPermissionsPolicyResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.codeartifact.model.UntagResourceResponse.ReadOnly
      ]
  object ListPackageVersions
      extends Stream[
        ListPackageVersionsRequest,
        AwsError,
        zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly
      ]
  object ListPackageVersionsPaginated
      extends Effect[
        ListPackageVersionsRequest,
        AwsError,
        zio.aws.codeartifact.model.ListPackageVersionsResponse.ReadOnly
      ]
  object DeleteDomainPermissionsPolicy
      extends Effect[
        DeleteDomainPermissionsPolicyRequest,
        AwsError,
        zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyResponse.ReadOnly
      ]
  object CopyPackageVersions
      extends Effect[
        CopyPackageVersionsRequest,
        AwsError,
        zio.aws.codeartifact.model.CopyPackageVersionsResponse.ReadOnly
      ]
  object PutDomainPermissionsPolicy
      extends Effect[
        PutDomainPermissionsPolicyRequest,
        AwsError,
        zio.aws.codeartifact.model.PutDomainPermissionsPolicyResponse.ReadOnly
      ]
  object ListRepositories
      extends Stream[
        ListRepositoriesRequest,
        AwsError,
        zio.aws.codeartifact.model.RepositorySummary.ReadOnly
      ]
  object ListRepositoriesPaginated
      extends Effect[
        ListRepositoriesRequest,
        AwsError,
        zio.aws.codeartifact.model.ListRepositoriesResponse.ReadOnly
      ]
  object GetRepositoryPermissionsPolicy
      extends Effect[
        GetRepositoryPermissionsPolicyRequest,
        AwsError,
        zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyResponse.ReadOnly
      ]
  object DescribePackageVersion
      extends Effect[
        DescribePackageVersionRequest,
        AwsError,
        zio.aws.codeartifact.model.DescribePackageVersionResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.codeartifact.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DisposePackageVersions
      extends Effect[
        DisposePackageVersionsRequest,
        AwsError,
        zio.aws.codeartifact.model.DisposePackageVersionsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.codeartifact.model.TagResourceResponse.ReadOnly
      ]
  object DeleteDomain
      extends Effect[
        DeleteDomainRequest,
        AwsError,
        zio.aws.codeartifact.model.DeleteDomainResponse.ReadOnly
      ]
  object ListRepositoriesInDomain
      extends Stream[
        ListRepositoriesInDomainRequest,
        AwsError,
        zio.aws.codeartifact.model.RepositorySummary.ReadOnly
      ]
  object ListRepositoriesInDomainPaginated
      extends Effect[
        ListRepositoriesInDomainRequest,
        AwsError,
        zio.aws.codeartifact.model.ListRepositoriesInDomainResponse.ReadOnly
      ]
  object PutRepositoryPermissionsPolicy
      extends Effect[
        PutRepositoryPermissionsPolicyRequest,
        AwsError,
        zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyResponse.ReadOnly
      ]
  object ListPackages
      extends Stream[
        ListPackagesRequest,
        AwsError,
        zio.aws.codeartifact.model.PackageSummary.ReadOnly
      ]
  object ListPackagesPaginated
      extends Effect[
        ListPackagesRequest,
        AwsError,
        zio.aws.codeartifact.model.ListPackagesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Codeartifact] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Codeartifact] { rts =>
        zio.ZIO.succeed {
          new Codeartifact {
            val api: CodeartifactAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Codeartifact = this
            def getAuthorizationToken(
                request: GetAuthorizationTokenRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.GetAuthorizationTokenResponse.ReadOnly
            ] = proxy(GetAuthorizationToken, request)
            def listPackageVersionDependencies(
                request: ListPackageVersionDependenciesRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse.ReadOnly
            ] = proxy(ListPackageVersionDependencies, request)
            def getPackageVersionAsset(
                request: GetPackageVersionAssetRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.codeartifact.model.GetPackageVersionAssetResponse.ReadOnly,
              Byte
            ]] = proxy(GetPackageVersionAsset, request)
            def describeDomain(request: DescribeDomainRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.DescribeDomainResponse.ReadOnly
            ] = proxy(DescribeDomain, request)
            def deletePackageVersions(
                request: DeletePackageVersionsRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.DeletePackageVersionsResponse.ReadOnly
            ] = proxy(DeletePackageVersions, request)
            def getRepositoryEndpoint(
                request: GetRepositoryEndpointRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.GetRepositoryEndpointResponse.ReadOnly
            ] = proxy(GetRepositoryEndpoint, request)
            def deleteRepository(request: DeleteRepositoryRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.DeleteRepositoryResponse.ReadOnly
            ] = proxy(DeleteRepository, request)
            def listPackageVersionAssets(
                request: ListPackageVersionAssetsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codeartifact.model.AssetSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPackageVersionAssets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPackageVersionAssetsPaginated(
                request: ListPackageVersionAssetsRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.ListPackageVersionAssetsResponse.ReadOnly
            ] = proxy(ListPackageVersionAssetsPaginated, request)
            def listDomains(request: ListDomainsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codeartifact.model.DomainSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDomains, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDomainsPaginated(request: ListDomainsRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.ListDomainsResponse.ReadOnly
            ] = proxy(ListDomainsPaginated, request)
            def disassociateExternalConnection(
                request: DisassociateExternalConnectionRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.DisassociateExternalConnectionResponse.ReadOnly
            ] = proxy(DisassociateExternalConnection, request)
            def updatePackageVersionsStatus(
                request: UpdatePackageVersionsStatusRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.UpdatePackageVersionsStatusResponse.ReadOnly
            ] = proxy(UpdatePackageVersionsStatus, request)
            def associateExternalConnection(
                request: AssociateExternalConnectionRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.AssociateExternalConnectionResponse.ReadOnly
            ] = proxy(AssociateExternalConnection, request)
            def updateRepository(request: UpdateRepositoryRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.UpdateRepositoryResponse.ReadOnly
            ] = proxy(UpdateRepository, request)
            def createRepository(request: CreateRepositoryRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.CreateRepositoryResponse.ReadOnly
            ] = proxy(CreateRepository, request)
            def deleteRepositoryPermissionsPolicy(
                request: DeleteRepositoryPermissionsPolicyRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse.ReadOnly
            ] = proxy(DeleteRepositoryPermissionsPolicy, request)
            def getPackageVersionReadme(
                request: GetPackageVersionReadmeRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.GetPackageVersionReadmeResponse.ReadOnly
            ] = proxy(GetPackageVersionReadme, request)
            def createDomain(
                request: CreateDomainRequest
            ): IO[AwsError, ReadOnly] = proxy(CreateDomain, request)
            def describeRepository(request: DescribeRepositoryRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.DescribeRepositoryResponse.ReadOnly
            ] = proxy(DescribeRepository, request)
            def getDomainPermissionsPolicy(
                request: GetDomainPermissionsPolicyRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.GetDomainPermissionsPolicyResponse.ReadOnly
            ] = proxy(GetDomainPermissionsPolicy, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listPackageVersions(
                request: ListPackageVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPackageVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPackageVersionsPaginated(
                request: ListPackageVersionsRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.ListPackageVersionsResponse.ReadOnly
            ] = proxy(ListPackageVersionsPaginated, request)
            def deleteDomainPermissionsPolicy(
                request: DeleteDomainPermissionsPolicyRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyResponse.ReadOnly
            ] = proxy(DeleteDomainPermissionsPolicy, request)
            def copyPackageVersions(request: CopyPackageVersionsRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.CopyPackageVersionsResponse.ReadOnly
            ] = proxy(CopyPackageVersions, request)
            def putDomainPermissionsPolicy(
                request: PutDomainPermissionsPolicyRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.PutDomainPermissionsPolicyResponse.ReadOnly
            ] = proxy(PutDomainPermissionsPolicy, request)
            def listRepositories(request: ListRepositoriesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codeartifact.model.RepositorySummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRepositories, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRepositoriesPaginated(request: ListRepositoriesRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.ListRepositoriesResponse.ReadOnly
            ] = proxy(ListRepositoriesPaginated, request)
            def getRepositoryPermissionsPolicy(
                request: GetRepositoryPermissionsPolicyRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyResponse.ReadOnly
            ] = proxy(GetRepositoryPermissionsPolicy, request)
            def describePackageVersion(
                request: DescribePackageVersionRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.DescribePackageVersionResponse.ReadOnly
            ] = proxy(DescribePackageVersion, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def disposePackageVersions(
                request: DisposePackageVersionsRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.DisposePackageVersionsResponse.ReadOnly
            ] = proxy(DisposePackageVersions, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def deleteDomain(request: DeleteDomainRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.DeleteDomainResponse.ReadOnly
            ] = proxy(DeleteDomain, request)
            def listRepositoriesInDomain(
                request: ListRepositoriesInDomainRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codeartifact.model.RepositorySummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRepositoriesInDomain, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRepositoriesInDomainPaginated(
                request: ListRepositoriesInDomainRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.ListRepositoriesInDomainResponse.ReadOnly
            ] = proxy(ListRepositoriesInDomainPaginated, request)
            def putRepositoryPermissionsPolicy(
                request: PutRepositoryPermissionsPolicyRequest
            ): IO[
              AwsError,
              zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyResponse.ReadOnly
            ] = proxy(PutRepositoryPermissionsPolicy, request)
            def listPackages(request: ListPackagesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codeartifact.model.PackageSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPackages, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPackagesPaginated(request: ListPackagesRequest): IO[
              AwsError,
              zio.aws.codeartifact.model.ListPackagesResponse.ReadOnly
            ] = proxy(ListPackagesPaginated, request)
          }
        }
      }
    }
  }
}
