package zio.aws.codeartifact.model
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  AccountId,
  DomainName,
  RepositoryName,
  PaginationToken,
  PackageNamespace,
  ListPackagesMaxResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPackagesRequest(
    domain: DomainName,
    domainOwner: Optional[AccountId] = Optional.Absent,
    repository: RepositoryName,
    format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      Optional.Absent,
    namespace: Optional[PackageNamespace] = Optional.Absent,
    packagePrefix: Optional[PackageName] = Optional.Absent,
    maxResults: Optional[ListPackagesMaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest = {
    import ListPackagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packagePrefix.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packagePrefix)
      .optionallyWith(
        maxResults.map(value => ListPackagesMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.ListPackagesRequest.ReadOnly =
    zio.aws.codeartifact.model.ListPackagesRequest.wrap(buildAwsValue())
}
object ListPackagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListPackagesRequest =
      zio.aws.codeartifact.model.ListPackagesRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        format.map(value => value),
        namespace.map(value => value),
        packagePrefix.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Optional[AccountId]
    def repository: RepositoryName
    def format: Optional[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Optional[PackageNamespace]
    def packagePrefix: Optional[PackageName]
    def maxResults: Optional[ListPackagesMaxResults]
    def nextToken: Optional[PaginationToken]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackagePrefix: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packagePrefix", packagePrefix)
    def getMaxResults: ZIO[Any, AwsError, ListPackagesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest
  ) extends zio.aws.codeartifact.model.ListPackagesRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packagePrefix: Optional[PackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.packagePrefix())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val maxResults: Optional[ListPackagesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codeartifact.model.primitives.ListPackagesMaxResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest
  ): zio.aws.codeartifact.model.ListPackagesRequest.ReadOnly = new Wrapper(impl)
}
