package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribePackageVersionResponse(
    packageVersion: zio.aws.codeartifact.model.PackageVersionDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionResponse = {
    import DescribePackageVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionResponse
      .builder()
      .packageVersion(packageVersion.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.DescribePackageVersionResponse.ReadOnly =
    zio.aws.codeartifact.model.DescribePackageVersionResponse
      .wrap(buildAwsValue())
}
object DescribePackageVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DescribePackageVersionResponse =
      zio.aws.codeartifact.model
        .DescribePackageVersionResponse(packageVersion.asEditable)
    def packageVersion
        : zio.aws.codeartifact.model.PackageVersionDescription.ReadOnly
    def getPackageVersion: ZIO[
      Any,
      Nothing,
      zio.aws.codeartifact.model.PackageVersionDescription.ReadOnly
    ] = ZIO.succeed(packageVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionResponse
  ) extends zio.aws.codeartifact.model.DescribePackageVersionResponse.ReadOnly {
    override val packageVersion
        : zio.aws.codeartifact.model.PackageVersionDescription.ReadOnly =
      zio.aws.codeartifact.model.PackageVersionDescription
        .wrap(impl.packageVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionResponse
  ): zio.aws.codeartifact.model.DescribePackageVersionResponse.ReadOnly =
    new Wrapper(impl)
}
