package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PolicyRevision,
  RepositoryName,
  AccountId,
  DomainName
}
import scala.jdk.CollectionConverters._
final case class DeleteRepositoryPermissionsPolicyRequest(
    domain: DomainName,
    domainOwner: Optional[AccountId] = Optional.Absent,
    repository: RepositoryName,
    policyRevision: Optional[PolicyRevision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest = {
    import DeleteRepositoryPermissionsPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .optionallyWith(
        policyRevision.map(value =>
          PolicyRevision.unwrap(value): java.lang.String
        )
      )(_.policyRevision)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest.ReadOnly =
    zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest
      .wrap(buildAwsValue())
}
object DeleteRepositoryPermissionsPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest =
      zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        policyRevision.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Optional[AccountId]
    def repository: RepositoryName
    def policyRevision: Optional[PolicyRevision]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getPolicyRevision: ZIO[Any, AwsError, PolicyRevision] =
      AwsError.unwrapOptionField("policyRevision", policyRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest
  ) extends zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val policyRevision: Optional[PolicyRevision] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyRevision())
        .map(value =>
          zio.aws.codeartifact.model.primitives.PolicyRevision(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest
  ): zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
