package zio.aws.codeartifact.model
import scala.jdk.CollectionConverters._
sealed trait PackageVersionStatus {
  def unwrap
      : software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus
}
object PackageVersionStatus {
  def wrap(
      value: software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus
  ): zio.aws.codeartifact.model.PackageVersionStatus = value match {
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.PUBLISHED =>
      val r = Published
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.UNFINISHED =>
      val r = Unfinished
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.UNLISTED =>
      val r = Unlisted
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.ARCHIVED =>
      val r = Archived
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.DISPOSED =>
      val r = Disposed
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.DELETED =>
      val r = Deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeartifact.model.PackageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Published
      extends zio.aws.codeartifact.model.PackageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.PUBLISHED
  }
  case object Unfinished
      extends zio.aws.codeartifact.model.PackageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.UNFINISHED
  }
  case object Unlisted extends zio.aws.codeartifact.model.PackageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.UNLISTED
  }
  case object Archived extends zio.aws.codeartifact.model.PackageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.ARCHIVED
  }
  case object Disposed extends zio.aws.codeartifact.model.PackageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.DISPOSED
  }
  case object Deleted extends zio.aws.codeartifact.model.PackageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus.DELETED
  }
}
