package zio.aws.codeartifact.model
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  AccountId,
  DomainName,
  RepositoryName,
  PaginationToken,
  PackageNamespace,
  ListPackageVersionsMaxResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPackageVersionsRequest(
    domain: DomainName,
    domainOwner: Optional[AccountId] = Optional.Absent,
    repository: RepositoryName,
    format: zio.aws.codeartifact.model.PackageFormat,
    namespace: Optional[PackageNamespace] = Optional.Absent,
    packageValue: PackageName,
    status: Optional[zio.aws.codeartifact.model.PackageVersionStatus] =
      Optional.Absent,
    sortBy: Optional[zio.aws.codeartifact.model.PackageVersionSortType] =
      Optional.Absent,
    maxResults: Optional[ListPackageVersionsMaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest = {
    import ListPackageVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .format(format.unwrap)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .packageValue(PackageName.unwrap(packageValue): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        maxResults.map(value =>
          ListPackageVersionsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListPackageVersionsRequest.ReadOnly =
    zio.aws.codeartifact.model.ListPackageVersionsRequest.wrap(buildAwsValue())
}
object ListPackageVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListPackageVersionsRequest =
      zio.aws.codeartifact.model.ListPackageVersionsRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        format,
        namespace.map(value => value),
        packageValue,
        status.map(value => value),
        sortBy.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Optional[AccountId]
    def repository: RepositoryName
    def format: zio.aws.codeartifact.model.PackageFormat
    def namespace: Optional[PackageNamespace]
    def packageValue: PackageName
    def status: Optional[zio.aws.codeartifact.model.PackageVersionStatus]
    def sortBy: Optional[zio.aws.codeartifact.model.PackageVersionSortType]
    def maxResults: Optional[ListPackageVersionsMaxResults]
    def nextToken: Optional[PaginationToken]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getFormat: ZIO[Any, Nothing, zio.aws.codeartifact.model.PackageFormat] =
      ZIO.succeed(format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, Nothing, PackageName] =
      ZIO.succeed(packageValue)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageVersionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.PackageVersionSortType
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getMaxResults: ZIO[Any, AwsError, ListPackageVersionsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest
  ) extends zio.aws.codeartifact.model.ListPackageVersionsRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val format: zio.aws.codeartifact.model.PackageFormat =
      zio.aws.codeartifact.model.PackageFormat.wrap(impl.format())
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: PackageName =
      zio.aws.codeartifact.model.primitives.PackageName(impl.packageValue())
    override val status
        : Optional[zio.aws.codeartifact.model.PackageVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.codeartifact.model.PackageVersionStatus.wrap(value)
        )
    override val sortBy
        : Optional[zio.aws.codeartifact.model.PackageVersionSortType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.codeartifact.model.PackageVersionSortType.wrap(value)
        )
    override val maxResults: Optional[ListPackageVersionsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codeartifact.model.primitives
            .ListPackageVersionsMaxResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest
  ): zio.aws.codeartifact.model.ListPackageVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
