package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.ExternalConnectionName
import scala.jdk.CollectionConverters._
final case class RepositoryExternalConnectionInfo(
    externalConnectionName: Option[ExternalConnectionName] = None,
    packageFormat: Option[zio.aws.codeartifact.model.PackageFormat] = None,
    status: Option[zio.aws.codeartifact.model.ExternalConnectionStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfo = {
    import RepositoryExternalConnectionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfo
      .builder()
      .optionallyWith(
        externalConnectionName.map(value =>
          ExternalConnectionName.unwrap(value): java.lang.String
        )
      )(_.externalConnectionName)
      .optionallyWith(packageFormat.map(value => value.unwrap))(_.packageFormat)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.RepositoryExternalConnectionInfo.ReadOnly =
    zio.aws.codeartifact.model.RepositoryExternalConnectionInfo
      .wrap(buildAwsValue())
}
object RepositoryExternalConnectionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.RepositoryExternalConnectionInfo =
      zio.aws.codeartifact.model.RepositoryExternalConnectionInfo(
        externalConnectionName.map(value => value),
        packageFormat.map(value => value),
        status.map(value => value)
      )
    def externalConnectionName: Option[ExternalConnectionName]
    def packageFormat: Option[zio.aws.codeartifact.model.PackageFormat]
    def status: Option[zio.aws.codeartifact.model.ExternalConnectionStatus]
    def getExternalConnectionName: ZIO[Any, AwsError, ExternalConnectionName] =
      AwsError.unwrapOptionField(
        "externalConnectionName",
        externalConnectionName
      )
    def getPackageFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("packageFormat", packageFormat)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.ExternalConnectionStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfo
  ) extends zio.aws.codeartifact.model.RepositoryExternalConnectionInfo.ReadOnly {
    override val externalConnectionName: Option[ExternalConnectionName] = scala
      .Option(impl.externalConnectionName())
      .map(value =>
        zio.aws.codeartifact.model.primitives.ExternalConnectionName(value)
      )
    override val packageFormat
        : Option[zio.aws.codeartifact.model.PackageFormat] = scala
      .Option(impl.packageFormat())
      .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val status
        : Option[zio.aws.codeartifact.model.ExternalConnectionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.codeartifact.model.ExternalConnectionStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfo
  ): zio.aws.codeartifact.model.RepositoryExternalConnectionInfo.ReadOnly =
    new Wrapper(impl)
}
