package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LicenseInfo(
    name: Option[String] = None,
    url: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.LicenseInfo = {
    import LicenseInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.LicenseInfo
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.LicenseInfo.ReadOnly =
    zio.aws.codeartifact.model.LicenseInfo.wrap(buildAwsValue())
}
object LicenseInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.LicenseInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.LicenseInfo =
      zio.aws.codeartifact.model
        .LicenseInfo(name.map(value => value), url.map(value => value))
    def name: Option[String]
    def url: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.LicenseInfo
  ) extends zio.aws.codeartifact.model.LicenseInfo.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val url: Option[String] =
      scala.Option(impl.url()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.LicenseInfo
  ): zio.aws.codeartifact.model.LicenseInfo.ReadOnly = new Wrapper(impl)
}
