package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDomainResponse(
    domain: Option[zio.aws.codeartifact.model.DomainDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DescribeDomainResponse = {
    import DescribeDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DescribeDomainResponse
      .builder()
      .optionallyWith(domain.map(value => value.buildAwsValue()))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.DescribeDomainResponse.ReadOnly =
    zio.aws.codeartifact.model.DescribeDomainResponse.wrap(buildAwsValue())
}
object DescribeDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DescribeDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DescribeDomainResponse =
      zio.aws.codeartifact.model
        .DescribeDomainResponse(domain.map(value => value.asEditable))
    def domain: Option[zio.aws.codeartifact.model.DomainDescription.ReadOnly]
    def getDomain: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.DomainDescription.ReadOnly
    ] = AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DescribeDomainResponse
  ) extends zio.aws.codeartifact.model.DescribeDomainResponse.ReadOnly {
    override val domain
        : Option[zio.aws.codeartifact.model.DomainDescription.ReadOnly] = scala
      .Option(impl.domain())
      .map(value => zio.aws.codeartifact.model.DomainDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DescribeDomainResponse
  ): zio.aws.codeartifact.model.DescribeDomainResponse.ReadOnly = new Wrapper(
    impl
  )
}
