package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  PackageVersion,
  PaginationToken,
  PackageNamespace,
  PackageVersionRevision
}
import scala.jdk.CollectionConverters._
final case class ListPackageVersionDependenciesResponse(
    format: Option[zio.aws.codeartifact.model.PackageFormat] = None,
    namespace: Option[PackageNamespace] = None,
    packageValue: Option[PackageName] = None,
    version: Option[PackageVersion] = None,
    versionRevision: Option[PackageVersionRevision] = None,
    nextToken: Option[PaginationToken] = None,
    dependencies: Option[
      Iterable[zio.aws.codeartifact.model.PackageDependency]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesResponse = {
    import ListPackageVersionDependenciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesResponse
      .builder()
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packageValue.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageValue)
      .optionallyWith(
        version.map(value => PackageVersion.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        versionRevision.map(value =>
          PackageVersionRevision.unwrap(value): java.lang.String
        )
      )(_.versionRevision)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        dependencies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dependencies)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse.ReadOnly =
    zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse
      .wrap(buildAwsValue())
}
object ListPackageVersionDependenciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse =
      zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse(
        format.map(value => value),
        namespace.map(value => value),
        packageValue.map(value => value),
        version.map(value => value),
        versionRevision.map(value => value),
        nextToken.map(value => value),
        dependencies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def format: Option[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Option[PackageNamespace]
    def packageValue: Option[PackageName]
    def version: Option[PackageVersion]
    def versionRevision: Option[PackageVersionRevision]
    def nextToken: Option[PaginationToken]
    def dependencies
        : Option[List[zio.aws.codeartifact.model.PackageDependency.ReadOnly]]
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageValue", packageValue)
    def getVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("version", version)
    def getVersionRevision: ZIO[Any, AwsError, PackageVersionRevision] =
      AwsError.unwrapOptionField("versionRevision", versionRevision)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDependencies: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.PackageDependency.ReadOnly
    ]] = AwsError.unwrapOptionField("dependencies", dependencies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesResponse
  ) extends zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse.ReadOnly {
    override val format: Option[zio.aws.codeartifact.model.PackageFormat] =
      scala
        .Option(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Option[PackageNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: Option[PackageName] = scala
      .Option(impl.packageValue())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val version: Option[PackageVersion] = scala
      .Option(impl.version())
      .map(value => zio.aws.codeartifact.model.primitives.PackageVersion(value))
    override val versionRevision: Option[PackageVersionRevision] = scala
      .Option(impl.versionRevision())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageVersionRevision(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
    override val dependencies
        : Option[List[zio.aws.codeartifact.model.PackageDependency.ReadOnly]] =
      scala
        .Option(impl.dependencies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codeartifact.model.PackageDependency.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesResponse
  ): zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse.ReadOnly =
    new Wrapper(impl)
}
