package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{PackageName, PackageNamespace}
import scala.jdk.CollectionConverters._
final case class PackageDependency(
    namespace: Option[PackageNamespace] = None,
    packageValue: Option[PackageName] = None,
    dependencyType: Option[String] = None,
    versionRequirement: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PackageDependency = {
    import PackageDependency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PackageDependency
      .builder()
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packageValue.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageValue)
      .optionallyWith(dependencyType.map(value => value: java.lang.String))(
        _.dependencyType
      )
      .optionallyWith(versionRequirement.map(value => value: java.lang.String))(
        _.versionRequirement
      )
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.PackageDependency.ReadOnly =
    zio.aws.codeartifact.model.PackageDependency.wrap(buildAwsValue())
}
object PackageDependency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PackageDependency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PackageDependency =
      zio.aws.codeartifact.model.PackageDependency(
        namespace.map(value => value),
        packageValue.map(value => value),
        dependencyType.map(value => value),
        versionRequirement.map(value => value)
      )
    def namespace: Option[PackageNamespace]
    def packageValue: Option[PackageName]
    def dependencyType: Option[String]
    def versionRequirement: Option[String]
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageValue", packageValue)
    def getDependencyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dependencyType", dependencyType)
    def getVersionRequirement: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionRequirement", versionRequirement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageDependency
  ) extends zio.aws.codeartifact.model.PackageDependency.ReadOnly {
    override val namespace: Option[PackageNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: Option[PackageName] = scala
      .Option(impl.packageValue())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val dependencyType: Option[String] =
      scala.Option(impl.dependencyType()).map(value => value: String)
    override val versionRequirement: Option[String] =
      scala.Option(impl.versionRequirement()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageDependency
  ): zio.aws.codeartifact.model.PackageDependency.ReadOnly = new Wrapper(impl)
}
