package zio.aws.codeartifact.model
import scala.jdk.CollectionConverters._
sealed trait ExternalConnectionStatus {
  def unwrap: software.amazon.awssdk.services.codeartifact.model.ExternalConnectionStatus
}
object ExternalConnectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.codeartifact.model.ExternalConnectionStatus
  ): zio.aws.codeartifact.model.ExternalConnectionStatus = value match {
    case software.amazon.awssdk.services.codeartifact.model.ExternalConnectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeartifact.model.ExternalConnectionStatus.AVAILABLE =>
      val r = Available
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeartifact.model.ExternalConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.ExternalConnectionStatus =
      software.amazon.awssdk.services.codeartifact.model.ExternalConnectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Available
      extends zio.aws.codeartifact.model.ExternalConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.ExternalConnectionStatus =
      software.amazon.awssdk.services.codeartifact.model.ExternalConnectionStatus.AVAILABLE
  }
}
