package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SuccessfulPackageVersionInfo(
    revision: Option[String] = None,
    status: Option[zio.aws.codeartifact.model.PackageVersionStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.SuccessfulPackageVersionInfo = {
    import SuccessfulPackageVersionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.SuccessfulPackageVersionInfo
      .builder()
      .optionallyWith(revision.map(value => value: java.lang.String))(
        _.revision
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly =
    zio.aws.codeartifact.model.SuccessfulPackageVersionInfo
      .wrap(buildAwsValue())
}
object SuccessfulPackageVersionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.SuccessfulPackageVersionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.SuccessfulPackageVersionInfo =
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo(
        revision.map(value => value),
        status.map(value => value)
      )
    def revision: Option[String]
    def status: Option[zio.aws.codeartifact.model.PackageVersionStatus]
    def getRevision: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revision", revision)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageVersionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.SuccessfulPackageVersionInfo
  ) extends zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly {
    override val revision: Option[String] =
      scala.Option(impl.revision()).map(value => value: String)
    override val status
        : Option[zio.aws.codeartifact.model.PackageVersionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.codeartifact.model.PackageVersionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.SuccessfulPackageVersionInfo
  ): zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly =
    new Wrapper(impl)
}
