package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  ExternalConnectionName,
  RepositoryName,
  AccountId,
  DomainName
}
import scala.jdk.CollectionConverters._
final case class DisassociateExternalConnectionRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    repository: RepositoryName,
    externalConnection: ExternalConnectionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionRequest = {
    import DisassociateExternalConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .externalConnection(
        ExternalConnectionName.unwrap(externalConnection): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.DisassociateExternalConnectionRequest.ReadOnly =
    zio.aws.codeartifact.model.DisassociateExternalConnectionRequest
      .wrap(buildAwsValue())
}
object DisassociateExternalConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.DisassociateExternalConnectionRequest =
      zio.aws.codeartifact.model.DisassociateExternalConnectionRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        externalConnection
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def repository: RepositoryName
    def externalConnection: ExternalConnectionName
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getExternalConnection: ZIO[Any, Nothing, ExternalConnectionName] =
      ZIO.succeed(externalConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionRequest
  ) extends zio.aws.codeartifact.model.DisassociateExternalConnectionRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val externalConnection: ExternalConnectionName =
      zio.aws.codeartifact.model.primitives
        .ExternalConnectionName(impl.externalConnection())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionRequest
  ): zio.aws.codeartifact.model.DisassociateExternalConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
