package zio.aws.codeartifact.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  AccountId,
  DomainName,
  RepositoryName,
  PaginationToken,
  PackageNamespace,
  ListPackagesMaxResults
}
import scala.jdk.CollectionConverters._
final case class ListPackagesRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    repository: RepositoryName,
    format: Option[zio.aws.codeartifact.model.PackageFormat] = None,
    namespace: Option[PackageNamespace] = None,
    packagePrefix: Option[PackageName] = None,
    maxResults: Option[ListPackagesMaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest = {
    import ListPackagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packagePrefix.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packagePrefix)
      .optionallyWith(
        maxResults.map(value => ListPackagesMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.ListPackagesRequest.ReadOnly =
    zio.aws.codeartifact.model.ListPackagesRequest.wrap(buildAwsValue())
}
object ListPackagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListPackagesRequest =
      zio.aws.codeartifact.model.ListPackagesRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        format.map(value => value),
        namespace.map(value => value),
        packagePrefix.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def repository: RepositoryName
    def format: Option[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Option[PackageNamespace]
    def packagePrefix: Option[PackageName]
    def maxResults: Option[ListPackagesMaxResults]
    def nextToken: Option[PaginationToken]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackagePrefix: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packagePrefix", packagePrefix)
    def getMaxResults: ZIO[Any, AwsError, ListPackagesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest
  ) extends zio.aws.codeartifact.model.ListPackagesRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val format: Option[zio.aws.codeartifact.model.PackageFormat] =
      scala
        .Option(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Option[PackageNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packagePrefix: Option[PackageName] = scala
      .Option(impl.packagePrefix())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val maxResults: Option[ListPackagesMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.codeartifact.model.primitives.ListPackagesMaxResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest
  ): zio.aws.codeartifact.model.ListPackagesRequest.ReadOnly = new Wrapper(impl)
}
