package zio.aws.codeartifact.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  PaginationToken,
  ListRepositoriesMaxResults,
  RepositoryName
}
import scala.jdk.CollectionConverters._
final case class ListRepositoriesRequest(
    repositoryPrefix: Option[RepositoryName] = None,
    maxResults: Option[ListRepositoriesMaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest = {
    import ListRepositoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest
      .builder()
      .optionallyWith(
        repositoryPrefix.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryPrefix)
      .optionallyWith(
        maxResults.map(value =>
          ListRepositoriesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.ListRepositoriesRequest.ReadOnly =
    zio.aws.codeartifact.model.ListRepositoriesRequest.wrap(buildAwsValue())
}
object ListRepositoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListRepositoriesRequest =
      zio.aws.codeartifact.model.ListRepositoriesRequest(
        repositoryPrefix.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def repositoryPrefix: Option[RepositoryName]
    def maxResults: Option[ListRepositoriesMaxResults]
    def nextToken: Option[PaginationToken]
    def getRepositoryPrefix: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryPrefix", repositoryPrefix)
    def getMaxResults: ZIO[Any, AwsError, ListRepositoriesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest
  ) extends zio.aws.codeartifact.model.ListRepositoriesRequest.ReadOnly {
    override val repositoryPrefix: Option[RepositoryName] = scala
      .Option(impl.repositoryPrefix())
      .map(value => zio.aws.codeartifact.model.primitives.RepositoryName(value))
    override val maxResults: Option[ListRepositoriesMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.codeartifact.model.primitives.ListRepositoriesMaxResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest
  ): zio.aws.codeartifact.model.ListRepositoriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
