package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribePackageResponse(
    packageValue: zio.aws.codeartifact.model.PackageDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DescribePackageResponse = {
    import DescribePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DescribePackageResponse
      .builder()
      .packageValue(packageValue.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.DescribePackageResponse.ReadOnly =
    zio.aws.codeartifact.model.DescribePackageResponse.wrap(buildAwsValue())
}
object DescribePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DescribePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DescribePackageResponse =
      zio.aws.codeartifact.model
        .DescribePackageResponse(packageValue.asEditable)
    def packageValue: zio.aws.codeartifact.model.PackageDescription.ReadOnly
    def getPackageValue: ZIO[
      Any,
      Nothing,
      zio.aws.codeartifact.model.PackageDescription.ReadOnly
    ] = ZIO.succeed(packageValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DescribePackageResponse
  ) extends zio.aws.codeartifact.model.DescribePackageResponse.ReadOnly {
    override val packageValue
        : zio.aws.codeartifact.model.PackageDescription.ReadOnly =
      zio.aws.codeartifact.model.PackageDescription.wrap(impl.packageValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DescribePackageResponse
  ): zio.aws.codeartifact.model.DescribePackageResponse.ReadOnly = new Wrapper(
    impl
  )
}
