package zio.aws.codeartifact.model
import scala.jdk.CollectionConverters._
sealed trait PackageVersionOriginType {
  def unwrap: software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType
}
object PackageVersionOriginType {
  def wrap(
      value: software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType
  ): zio.aws.codeartifact.model.PackageVersionOriginType = value match {
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType.INTERNAL =>
      val r = INTERNAL
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType.EXTERNAL =>
      val r = EXTERNAL
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeartifact.model.PackageVersionOriginType {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL
      extends zio.aws.codeartifact.model.PackageVersionOriginType {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType.INTERNAL
  }
  case object EXTERNAL
      extends zio.aws.codeartifact.model.PackageVersionOriginType {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType.EXTERNAL
  }
  case object UNKNOWN
      extends zio.aws.codeartifact.model.PackageVersionOriginType {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType.UNKNOWN
  }
}
