package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{PackageName, PackageNamespace}
import scala.jdk.CollectionConverters._
final case class PackageDescription(
    format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      Optional.Absent,
    namespace: Optional[PackageNamespace] = Optional.Absent,
    name: Optional[PackageName] = Optional.Absent,
    originConfiguration: Optional[
      zio.aws.codeartifact.model.PackageOriginConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PackageDescription = {
    import PackageDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PackageDescription
      .builder()
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        name.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(originConfiguration.map(value => value.buildAwsValue()))(
        _.originConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.PackageDescription.ReadOnly =
    zio.aws.codeartifact.model.PackageDescription.wrap(buildAwsValue())
}
object PackageDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PackageDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PackageDescription =
      zio.aws.codeartifact.model.PackageDescription(
        format.map(value => value),
        namespace.map(value => value),
        name.map(value => value),
        originConfiguration.map(value => value.asEditable)
      )
    def format: Optional[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Optional[PackageNamespace]
    def name: Optional[PackageName]
    def originConfiguration: Optional[
      zio.aws.codeartifact.model.PackageOriginConfiguration.ReadOnly
    ]
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getName: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("name", name)
    def getOriginConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.PackageOriginConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("originConfiguration", originConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageDescription
  ) extends zio.aws.codeartifact.model.PackageDescription.ReadOnly {
    override val format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val name: Optional[PackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val originConfiguration: Optional[
      zio.aws.codeartifact.model.PackageOriginConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.originConfiguration())
      .map(value =>
        zio.aws.codeartifact.model.PackageOriginConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageDescription
  ): zio.aws.codeartifact.model.PackageDescription.ReadOnly = new Wrapper(impl)
}
