package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  PackageVersion,
  PaginationToken,
  PackageNamespace,
  PackageVersionRevision
}
import scala.jdk.CollectionConverters._
final case class ListPackageVersionDependenciesResponse(
    format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      Optional.Absent,
    namespace: Optional[PackageNamespace] = Optional.Absent,
    packageValue: Optional[PackageName] = Optional.Absent,
    version: Optional[PackageVersion] = Optional.Absent,
    versionRevision: Optional[PackageVersionRevision] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    dependencies: Optional[
      Iterable[zio.aws.codeartifact.model.PackageDependency]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesResponse = {
    import ListPackageVersionDependenciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesResponse
      .builder()
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packageValue.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageValue)
      .optionallyWith(
        version.map(value => PackageVersion.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        versionRevision.map(value =>
          PackageVersionRevision.unwrap(value): java.lang.String
        )
      )(_.versionRevision)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        dependencies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dependencies)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse.ReadOnly =
    zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse
      .wrap(buildAwsValue())
}
object ListPackageVersionDependenciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse =
      zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse(
        format.map(value => value),
        namespace.map(value => value),
        packageValue.map(value => value),
        version.map(value => value),
        versionRevision.map(value => value),
        nextToken.map(value => value),
        dependencies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def format: Optional[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Optional[PackageNamespace]
    def packageValue: Optional[PackageName]
    def version: Optional[PackageVersion]
    def versionRevision: Optional[PackageVersionRevision]
    def nextToken: Optional[PaginationToken]
    def dependencies
        : Optional[List[zio.aws.codeartifact.model.PackageDependency.ReadOnly]]
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageValue", packageValue)
    def getVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("version", version)
    def getVersionRevision: ZIO[Any, AwsError, PackageVersionRevision] =
      AwsError.unwrapOptionField("versionRevision", versionRevision)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDependencies: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.PackageDependency.ReadOnly
    ]] = AwsError.unwrapOptionField("dependencies", dependencies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesResponse
  ) extends zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse.ReadOnly {
    override val format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: Optional[PackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.packageValue())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val version: Optional[PackageVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.codeartifact.model.primitives.PackageVersion(value))
    override val versionRevision: Optional[PackageVersionRevision] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionRevision())
        .map(value =>
          zio.aws.codeartifact.model.primitives.PackageVersionRevision(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
    override val dependencies: Optional[
      List[zio.aws.codeartifact.model.PackageDependency.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dependencies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codeartifact.model.PackageDependency.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesResponse
  ): zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse.ReadOnly =
    new Wrapper(impl)
}
