package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PolicyRevision,
  AccountId,
  DomainName
}
import scala.jdk.CollectionConverters._
final case class DeleteDomainPermissionsPolicyRequest(
    domain: DomainName,
    domainOwner: Optional[AccountId] = Optional.Absent,
    policyRevision: Optional[PolicyRevision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyRequest = {
    import DeleteDomainPermissionsPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .optionallyWith(
        policyRevision.map(value =>
          PolicyRevision.unwrap(value): java.lang.String
        )
      )(_.policyRevision)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyRequest.ReadOnly =
    zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyRequest
      .wrap(buildAwsValue())
}
object DeleteDomainPermissionsPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyRequest =
      zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyRequest(
        domain,
        domainOwner.map(value => value),
        policyRevision.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Optional[AccountId]
    def policyRevision: Optional[PolicyRevision]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getPolicyRevision: ZIO[Any, AwsError, PolicyRevision] =
      AwsError.unwrapOptionField("policyRevision", policyRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyRequest
  ) extends zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val policyRevision: Optional[PolicyRevision] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyRevision())
        .map(value =>
          zio.aws.codeartifact.model.primitives.PolicyRevision(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyRequest
  ): zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
