package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteRepositoryResponse(
    repository: Optional[zio.aws.codeartifact.model.RepositoryDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryResponse = {
    import DeleteRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryResponse
      .builder()
      .optionallyWith(repository.map(value => value.buildAwsValue()))(
        _.repository
      )
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.DeleteRepositoryResponse.ReadOnly =
    zio.aws.codeartifact.model.DeleteRepositoryResponse.wrap(buildAwsValue())
}
object DeleteRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DeleteRepositoryResponse =
      zio.aws.codeartifact.model
        .DeleteRepositoryResponse(repository.map(value => value.asEditable))
    def repository
        : Optional[zio.aws.codeartifact.model.RepositoryDescription.ReadOnly]
    def getRepository: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.RepositoryDescription.ReadOnly
    ] = AwsError.unwrapOptionField("repository", repository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryResponse
  ) extends zio.aws.codeartifact.model.DeleteRepositoryResponse.ReadOnly {
    override val repository
        : Optional[zio.aws.codeartifact.model.RepositoryDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repository())
        .map(value =>
          zio.aws.codeartifact.model.RepositoryDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryResponse
  ): zio.aws.codeartifact.model.DeleteRepositoryResponse.ReadOnly = new Wrapper(
    impl
  )
}
