package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteDomainResponse(
    domain: Optional[zio.aws.codeartifact.model.DomainDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DeleteDomainResponse = {
    import DeleteDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DeleteDomainResponse
      .builder()
      .optionallyWith(domain.map(value => value.buildAwsValue()))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.DeleteDomainResponse.ReadOnly =
    zio.aws.codeartifact.model.DeleteDomainResponse.wrap(buildAwsValue())
}
object DeleteDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DeleteDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DeleteDomainResponse =
      zio.aws.codeartifact.model
        .DeleteDomainResponse(domain.map(value => value.asEditable))
    def domain: Optional[zio.aws.codeartifact.model.DomainDescription.ReadOnly]
    def getDomain: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.DomainDescription.ReadOnly
    ] = AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteDomainResponse
  ) extends zio.aws.codeartifact.model.DeleteDomainResponse.ReadOnly {
    override val domain
        : Optional[zio.aws.codeartifact.model.DomainDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.codeartifact.model.DomainDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteDomainResponse
  ): zio.aws.codeartifact.model.DeleteDomainResponse.ReadOnly = new Wrapper(
    impl
  )
}
