package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.PackageVersion
import scala.jdk.CollectionConverters._
final case class DeletePackageVersionsResponse(
    successfulVersions: Optional[Map[
      PackageVersion,
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo
    ]] = Optional.Absent,
    failedVersions: Optional[
      Map[PackageVersion, zio.aws.codeartifact.model.PackageVersionError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsResponse = {
    import DeletePackageVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsResponse
      .builder()
      .optionallyWith(
        successfulVersions.map(value =>
          value
            .map({ case (key, value) =>
              (PackageVersion.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.successfulVersions)
      .optionallyWith(
        failedVersions.map(value =>
          value
            .map({ case (key, value) =>
              (PackageVersion.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.failedVersions)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.DeletePackageVersionsResponse.ReadOnly =
    zio.aws.codeartifact.model.DeletePackageVersionsResponse
      .wrap(buildAwsValue())
}
object DeletePackageVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DeletePackageVersionsResponse =
      zio.aws.codeartifact.model.DeletePackageVersionsResponse(
        successfulVersions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        failedVersions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def successfulVersions: Optional[Map[
      PackageVersion,
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly
    ]]
    def failedVersions: Optional[Map[
      PackageVersion,
      zio.aws.codeartifact.model.PackageVersionError.ReadOnly
    ]]
    def getSuccessfulVersions: ZIO[Any, AwsError, Map[
      PackageVersion,
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("successfulVersions", successfulVersions)
    def getFailedVersions: ZIO[Any, AwsError, Map[
      PackageVersion,
      zio.aws.codeartifact.model.PackageVersionError.ReadOnly
    ]] = AwsError.unwrapOptionField("failedVersions", failedVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsResponse
  ) extends zio.aws.codeartifact.model.DeletePackageVersionsResponse.ReadOnly {
    override val successfulVersions: Optional[Map[
      PackageVersion,
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.successfulVersions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codeartifact.model.primitives.PackageVersion(
              key
            ) -> zio.aws.codeartifact.model.SuccessfulPackageVersionInfo
              .wrap(value)
          })
          .toMap
      )
    override val failedVersions: Optional[Map[
      PackageVersion,
      zio.aws.codeartifact.model.PackageVersionError.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.failedVersions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codeartifact.model.primitives.PackageVersion(
              key
            ) -> zio.aws.codeartifact.model.PackageVersionError.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsResponse
  ): zio.aws.codeartifact.model.DeletePackageVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
