package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  AccountId,
  DomainName,
  RepositoryName,
  PackageVersion,
  PackageNamespace
}
import scala.jdk.CollectionConverters._
final case class DeletePackageVersionsRequest(
    domain: DomainName,
    domainOwner: Optional[AccountId] = Optional.Absent,
    repository: RepositoryName,
    format: zio.aws.codeartifact.model.PackageFormat,
    namespace: Optional[PackageNamespace] = Optional.Absent,
    packageValue: PackageName,
    versions: Iterable[PackageVersion],
    expectedStatus: Optional[zio.aws.codeartifact.model.PackageVersionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsRequest = {
    import DeletePackageVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .format(format.unwrap)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .packageValue(PackageName.unwrap(packageValue): java.lang.String)
      .versions(versions.map { item =>
        PackageVersion.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(expectedStatus.map(value => value.unwrap))(
        _.expectedStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.DeletePackageVersionsRequest.ReadOnly =
    zio.aws.codeartifact.model.DeletePackageVersionsRequest
      .wrap(buildAwsValue())
}
object DeletePackageVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DeletePackageVersionsRequest =
      zio.aws.codeartifact.model.DeletePackageVersionsRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        format,
        namespace.map(value => value),
        packageValue,
        versions,
        expectedStatus.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Optional[AccountId]
    def repository: RepositoryName
    def format: zio.aws.codeartifact.model.PackageFormat
    def namespace: Optional[PackageNamespace]
    def packageValue: PackageName
    def versions: List[PackageVersion]
    def expectedStatus
        : Optional[zio.aws.codeartifact.model.PackageVersionStatus]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getFormat: ZIO[Any, Nothing, zio.aws.codeartifact.model.PackageFormat] =
      ZIO.succeed(format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, Nothing, PackageName] =
      ZIO.succeed(packageValue)
    def getVersions: ZIO[Any, Nothing, List[PackageVersion]] =
      ZIO.succeed(versions)
    def getExpectedStatus
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageVersionStatus] =
      AwsError.unwrapOptionField("expectedStatus", expectedStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsRequest
  ) extends zio.aws.codeartifact.model.DeletePackageVersionsRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val format: zio.aws.codeartifact.model.PackageFormat =
      zio.aws.codeartifact.model.PackageFormat.wrap(impl.format())
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: PackageName =
      zio.aws.codeartifact.model.primitives.PackageName(impl.packageValue())
    override val versions: List[PackageVersion] = impl
      .versions()
      .asScala
      .map { item =>
        zio.aws.codeartifact.model.primitives.PackageVersion(item)
      }
      .toList
    override val expectedStatus
        : Optional[zio.aws.codeartifact.model.PackageVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedStatus())
        .map(value =>
          zio.aws.codeartifact.model.PackageVersionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsRequest
  ): zio.aws.codeartifact.model.DeletePackageVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
