package zio.aws.codeartifact.model
import scala.jdk.CollectionConverters._
sealed trait AllowPublish {
  def unwrap: software.amazon.awssdk.services.codeartifact.model.AllowPublish
}
object AllowPublish {
  def wrap(
      value: software.amazon.awssdk.services.codeartifact.model.AllowPublish
  ): zio.aws.codeartifact.model.AllowPublish = value match {
    case software.amazon.awssdk.services.codeartifact.model.AllowPublish.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeartifact.model.AllowPublish.ALLOW =>
      val r = ALLOW
      r
    case software.amazon.awssdk.services.codeartifact.model.AllowPublish.BLOCK =>
      val r = BLOCK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeartifact.model.AllowPublish {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.AllowPublish =
      software.amazon.awssdk.services.codeartifact.model.AllowPublish.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW extends zio.aws.codeartifact.model.AllowPublish {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.AllowPublish =
      software.amazon.awssdk.services.codeartifact.model.AllowPublish.ALLOW
  }
  case object BLOCK extends zio.aws.codeartifact.model.AllowPublish {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.AllowPublish =
      software.amazon.awssdk.services.codeartifact.model.AllowPublish.BLOCK
  }
}
