package zio.aws.codeartifact.model
import zio.aws.codeartifact.model.primitives.{
  PaginationToken,
  ListRepositoriesMaxResults,
  RepositoryName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRepositoriesRequest(
    repositoryPrefix: Optional[RepositoryName] = Optional.Absent,
    maxResults: Optional[ListRepositoriesMaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest = {
    import ListRepositoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest
      .builder()
      .optionallyWith(
        repositoryPrefix.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryPrefix)
      .optionallyWith(
        maxResults.map(value =>
          ListRepositoriesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.ListRepositoriesRequest.ReadOnly =
    zio.aws.codeartifact.model.ListRepositoriesRequest.wrap(buildAwsValue())
}
object ListRepositoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListRepositoriesRequest =
      zio.aws.codeartifact.model.ListRepositoriesRequest(
        repositoryPrefix.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def repositoryPrefix: Optional[RepositoryName]
    def maxResults: Optional[ListRepositoriesMaxResults]
    def nextToken: Optional[PaginationToken]
    def getRepositoryPrefix: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryPrefix", repositoryPrefix)
    def getMaxResults: ZIO[Any, AwsError, ListRepositoriesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest
  ) extends zio.aws.codeartifact.model.ListRepositoriesRequest.ReadOnly {
    override val repositoryPrefix: Optional[RepositoryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryPrefix())
        .map(value =>
          zio.aws.codeartifact.model.primitives.RepositoryName(value)
        )
    override val maxResults: Optional[ListRepositoriesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codeartifact.model.primitives
            .ListRepositoriesMaxResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest
  ): zio.aws.codeartifact.model.ListRepositoriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
