package zio.aws.codeartifact.model
import scala.jdk.CollectionConverters._
sealed trait PackageVersionSortType {
  def unwrap: software.amazon.awssdk.services.codeartifact.model.PackageVersionSortType
}
object PackageVersionSortType {
  def wrap(
      value: software.amazon.awssdk.services.codeartifact.model.PackageVersionSortType
  ): zio.aws.codeartifact.model.PackageVersionSortType = value match {
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionSortType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionSortType.PUBLISHED_TIME =>
      val r = PUBLISHED_TIME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeartifact.model.PackageVersionSortType {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionSortType =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionSortType.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLISHED_TIME
      extends zio.aws.codeartifact.model.PackageVersionSortType {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionSortType =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionSortType.PUBLISHED_TIME
  }
}
