package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteRepositoryPermissionsPolicyResponse(
    policy: Optional[zio.aws.codeartifact.model.ResourcePolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse = {
    import DeleteRepositoryPermissionsPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse.ReadOnly =
    zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse
      .wrap(buildAwsValue())
}
object DeleteRepositoryPermissionsPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse =
      zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse(
        policy.map(value => value.asEditable)
      )
    def policy: Optional[zio.aws.codeartifact.model.ResourcePolicy.ReadOnly]
    def getPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.ResourcePolicy.ReadOnly
    ] = AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse
  ) extends zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse.ReadOnly {
    override val policy
        : Optional[zio.aws.codeartifact.model.ResourcePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value => zio.aws.codeartifact.model.ResourcePolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse
  ): zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
