package zio.aws.codeartifact.model
import scala.jdk.CollectionConverters._
sealed trait DomainStatus {
  def unwrap: software.amazon.awssdk.services.codeartifact.model.DomainStatus
}
object DomainStatus {
  def wrap(
      value: software.amazon.awssdk.services.codeartifact.model.DomainStatus
  ): zio.aws.codeartifact.model.DomainStatus = value match {
    case software.amazon.awssdk.services.codeartifact.model.DomainStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeartifact.model.DomainStatus.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.codeartifact.model.DomainStatus.DELETED =>
      val r = Deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeartifact.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.DomainStatus =
      software.amazon.awssdk.services.codeartifact.model.DomainStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.codeartifact.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.DomainStatus =
      software.amazon.awssdk.services.codeartifact.model.DomainStatus.ACTIVE
  }
  case object Deleted extends zio.aws.codeartifact.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.DomainStatus =
      software.amazon.awssdk.services.codeartifact.model.DomainStatus.DELETED
  }
}
