package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PaginationToken,
  PackageName,
  PackageNamespace,
  PackageVersion
}
import scala.jdk.CollectionConverters._
final case class ListPackageVersionsResponse(
    defaultDisplayVersion: Optional[PackageVersion] = Optional.Absent,
    format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      Optional.Absent,
    namespace: Optional[PackageNamespace] = Optional.Absent,
    packageValue: Optional[PackageName] = Optional.Absent,
    versions: Optional[
      Iterable[zio.aws.codeartifact.model.PackageVersionSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse = {
    import ListPackageVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse
      .builder()
      .optionallyWith(
        defaultDisplayVersion.map(value =>
          PackageVersion.unwrap(value): java.lang.String
        )
      )(_.defaultDisplayVersion)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packageValue.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageValue)
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListPackageVersionsResponse.ReadOnly =
    zio.aws.codeartifact.model.ListPackageVersionsResponse.wrap(buildAwsValue())
}
object ListPackageVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListPackageVersionsResponse =
      zio.aws.codeartifact.model.ListPackageVersionsResponse(
        defaultDisplayVersion.map(value => value),
        format.map(value => value),
        namespace.map(value => value),
        packageValue.map(value => value),
        versions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def defaultDisplayVersion: Optional[PackageVersion]
    def format: Optional[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Optional[PackageNamespace]
    def packageValue: Optional[PackageName]
    def versions: Optional[
      List[zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getDefaultDisplayVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("defaultDisplayVersion", defaultDisplayVersion)
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageValue", packageValue)
    def getVersions: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("versions", versions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse
  ) extends zio.aws.codeartifact.model.ListPackageVersionsResponse.ReadOnly {
    override val defaultDisplayVersion: Optional[PackageVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultDisplayVersion())
        .map(value =>
          zio.aws.codeartifact.model.primitives.PackageVersion(value)
        )
    override val format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: Optional[PackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.packageValue())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val versions: Optional[
      List[zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codeartifact.model.PackageVersionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse
  ): zio.aws.codeartifact.model.ListPackageVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
