package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SuccessfulPackageVersionInfo(
    revision: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.codeartifact.model.PackageVersionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.SuccessfulPackageVersionInfo = {
    import SuccessfulPackageVersionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.SuccessfulPackageVersionInfo
      .builder()
      .optionallyWith(revision.map(value => value: java.lang.String))(
        _.revision
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly =
    zio.aws.codeartifact.model.SuccessfulPackageVersionInfo
      .wrap(buildAwsValue())
}
object SuccessfulPackageVersionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.SuccessfulPackageVersionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.SuccessfulPackageVersionInfo =
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo(
        revision.map(value => value),
        status.map(value => value)
      )
    def revision: Optional[String]
    def status: Optional[zio.aws.codeartifact.model.PackageVersionStatus]
    def getRevision: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revision", revision)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageVersionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.SuccessfulPackageVersionInfo
  ) extends zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly {
    override val revision: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.codeartifact.model.PackageVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.codeartifact.model.PackageVersionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.SuccessfulPackageVersionInfo
  ): zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly =
    new Wrapper(impl)
}
