package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PackageVersionRevision,
  PackageVersion
}
import scala.jdk.CollectionConverters._
final case class PackageVersionSummary(
    version: PackageVersion,
    revision: Optional[PackageVersionRevision] = Optional.Absent,
    status: zio.aws.codeartifact.model.PackageVersionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PackageVersionSummary = {
    import PackageVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PackageVersionSummary
      .builder()
      .version(PackageVersion.unwrap(version): java.lang.String)
      .optionallyWith(
        revision.map(value =>
          PackageVersionRevision.unwrap(value): java.lang.String
        )
      )(_.revision)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly =
    zio.aws.codeartifact.model.PackageVersionSummary.wrap(buildAwsValue())
}
object PackageVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PackageVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PackageVersionSummary =
      zio.aws.codeartifact.model
        .PackageVersionSummary(version, revision.map(value => value), status)
    def version: PackageVersion
    def revision: Optional[PackageVersionRevision]
    def status: zio.aws.codeartifact.model.PackageVersionStatus
    def getVersion: ZIO[Any, Nothing, PackageVersion] = ZIO.succeed(version)
    def getRevision: ZIO[Any, AwsError, PackageVersionRevision] =
      AwsError.unwrapOptionField("revision", revision)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.codeartifact.model.PackageVersionStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageVersionSummary
  ) extends zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly {
    override val version: PackageVersion =
      zio.aws.codeartifact.model.primitives.PackageVersion(impl.version())
    override val revision: Optional[PackageVersionRevision] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revision())
        .map(value =>
          zio.aws.codeartifact.model.primitives.PackageVersionRevision(value)
        )
    override val status: zio.aws.codeartifact.model.PackageVersionStatus =
      zio.aws.codeartifact.model.PackageVersionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageVersionSummary
  ): zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly = new Wrapper(
    impl
  )
}
