package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListDomainsResponse(
    domains: Option[Iterable[zio.aws.codeartifact.model.DomainSummary]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListDomainsResponse = {
    import ListDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListDomainsResponse
      .builder()
      .optionallyWith(
        domains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domains)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.ListDomainsResponse.ReadOnly =
    zio.aws.codeartifact.model.ListDomainsResponse.wrap(buildAwsValue())
}
object ListDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListDomainsResponse =
      zio.aws.codeartifact.model.ListDomainsResponse(
        domains.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def domains: Option[List[zio.aws.codeartifact.model.DomainSummary.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getDomains: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.DomainSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("domains", domains)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListDomainsResponse
  ) extends zio.aws.codeartifact.model.ListDomainsResponse.ReadOnly {
    override val domains
        : Option[List[zio.aws.codeartifact.model.DomainSummary.ReadOnly]] =
      scala
        .Option(impl.domains())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codeartifact.model.DomainSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListDomainsResponse
  ): zio.aws.codeartifact.model.ListDomainsResponse.ReadOnly = new Wrapper(impl)
}
