package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  AccountId,
  DomainName,
  RepositoryName,
  PackageVersion,
  PackageNamespace,
  PackageVersionRevision
}
import scala.jdk.CollectionConverters._
final case class UpdatePackageVersionsStatusRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    repository: RepositoryName,
    format: zio.aws.codeartifact.model.PackageFormat,
    namespace: Option[PackageNamespace] = None,
    packageValue: PackageName,
    versions: Iterable[PackageVersion],
    versionRevisions: Option[Map[PackageVersion, PackageVersionRevision]] =
      None,
    expectedStatus: Option[zio.aws.codeartifact.model.PackageVersionStatus] =
      None,
    targetStatus: zio.aws.codeartifact.model.PackageVersionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.UpdatePackageVersionsStatusRequest = {
    import UpdatePackageVersionsStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.UpdatePackageVersionsStatusRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .format(format.unwrap)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .packageValue(PackageName.unwrap(packageValue): java.lang.String)
      .versions(versions.map { item =>
        PackageVersion.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        versionRevisions.map(value =>
          value
            .map({ case (key, value) =>
              (PackageVersion.unwrap(
                key
              ): java.lang.String) -> (PackageVersionRevision.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.versionRevisions)
      .optionallyWith(expectedStatus.map(value => value.unwrap))(
        _.expectedStatus
      )
      .targetStatus(targetStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.UpdatePackageVersionsStatusRequest.ReadOnly =
    zio.aws.codeartifact.model.UpdatePackageVersionsStatusRequest
      .wrap(buildAwsValue())
}
object UpdatePackageVersionsStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.UpdatePackageVersionsStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.UpdatePackageVersionsStatusRequest =
      zio.aws.codeartifact.model.UpdatePackageVersionsStatusRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        format,
        namespace.map(value => value),
        packageValue,
        versions,
        versionRevisions.map(value => value),
        expectedStatus.map(value => value),
        targetStatus
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def repository: RepositoryName
    def format: zio.aws.codeartifact.model.PackageFormat
    def namespace: Option[PackageNamespace]
    def packageValue: PackageName
    def versions: List[PackageVersion]
    def versionRevisions: Option[Map[PackageVersion, PackageVersionRevision]]
    def expectedStatus: Option[zio.aws.codeartifact.model.PackageVersionStatus]
    def targetStatus: zio.aws.codeartifact.model.PackageVersionStatus
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getFormat: ZIO[Any, Nothing, zio.aws.codeartifact.model.PackageFormat] =
      ZIO.succeed(format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, Nothing, PackageName] =
      ZIO.succeed(packageValue)
    def getVersions: ZIO[Any, Nothing, List[PackageVersion]] =
      ZIO.succeed(versions)
    def getVersionRevisions
        : ZIO[Any, AwsError, Map[PackageVersion, PackageVersionRevision]] =
      AwsError.unwrapOptionField("versionRevisions", versionRevisions)
    def getExpectedStatus
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageVersionStatus] =
      AwsError.unwrapOptionField("expectedStatus", expectedStatus)
    def getTargetStatus
        : ZIO[Any, Nothing, zio.aws.codeartifact.model.PackageVersionStatus] =
      ZIO.succeed(targetStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.UpdatePackageVersionsStatusRequest
  ) extends zio.aws.codeartifact.model.UpdatePackageVersionsStatusRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val format: zio.aws.codeartifact.model.PackageFormat =
      zio.aws.codeartifact.model.PackageFormat.wrap(impl.format())
    override val namespace: Option[PackageNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: PackageName =
      zio.aws.codeartifact.model.primitives.PackageName(impl.packageValue())
    override val versions: List[PackageVersion] = impl
      .versions()
      .asScala
      .map { item =>
        zio.aws.codeartifact.model.primitives.PackageVersion(item)
      }
      .toList
    override val versionRevisions
        : Option[Map[PackageVersion, PackageVersionRevision]] = scala
      .Option(impl.versionRevisions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codeartifact.model.primitives
              .PackageVersion(key) -> zio.aws.codeartifact.model.primitives
              .PackageVersionRevision(value)
          })
          .toMap
      )
    override val expectedStatus
        : Option[zio.aws.codeartifact.model.PackageVersionStatus] = scala
      .Option(impl.expectedStatus())
      .map(value => zio.aws.codeartifact.model.PackageVersionStatus.wrap(value))
    override val targetStatus: zio.aws.codeartifact.model.PackageVersionStatus =
      zio.aws.codeartifact.model.PackageVersionStatus.wrap(impl.targetStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.UpdatePackageVersionsStatusRequest
  ): zio.aws.codeartifact.model.UpdatePackageVersionsStatusRequest.ReadOnly =
    new Wrapper(impl)
}
