package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{PackageName, PackageNamespace}
import scala.jdk.CollectionConverters._
final case class PackageSummary(
    format: Option[zio.aws.codeartifact.model.PackageFormat] = None,
    namespace: Option[PackageNamespace] = None,
    packageValue: Option[PackageName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PackageSummary = {
    import PackageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PackageSummary
      .builder()
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packageValue.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageValue)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.PackageSummary.ReadOnly =
    zio.aws.codeartifact.model.PackageSummary.wrap(buildAwsValue())
}
object PackageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PackageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PackageSummary =
      zio.aws.codeartifact.model.PackageSummary(
        format.map(value => value),
        namespace.map(value => value),
        packageValue.map(value => value)
      )
    def format: Option[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Option[PackageNamespace]
    def packageValue: Option[PackageName]
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageValue", packageValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageSummary
  ) extends zio.aws.codeartifact.model.PackageSummary.ReadOnly {
    override val format: Option[zio.aws.codeartifact.model.PackageFormat] =
      scala
        .Option(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Option[PackageNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: Option[PackageName] = scala
      .Option(impl.packageValue())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageSummary
  ): zio.aws.codeartifact.model.PackageSummary.ReadOnly = new Wrapper(impl)
}
