package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRepositoryEndpointResponse(
    repositoryEndpoint: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointResponse = {
    import GetRepositoryEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointResponse
      .builder()
      .optionallyWith(repositoryEndpoint.map(value => value: java.lang.String))(
        _.repositoryEndpoint
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.GetRepositoryEndpointResponse.ReadOnly =
    zio.aws.codeartifact.model.GetRepositoryEndpointResponse
      .wrap(buildAwsValue())
}
object GetRepositoryEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.GetRepositoryEndpointResponse =
      zio.aws.codeartifact.model
        .GetRepositoryEndpointResponse(repositoryEndpoint.map(value => value))
    def repositoryEndpoint: Option[String]
    def getRepositoryEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("repositoryEndpoint", repositoryEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointResponse
  ) extends zio.aws.codeartifact.model.GetRepositoryEndpointResponse.ReadOnly {
    override val repositoryEndpoint: Option[String] =
      scala.Option(impl.repositoryEndpoint()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointResponse
  ): zio.aws.codeartifact.model.GetRepositoryEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
