package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Option[Iterable[zio.aws.codeartifact.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.codeartifact.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListTagsForResourceResponse =
      zio.aws.codeartifact.model.ListTagsForResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Option[List[zio.aws.codeartifact.model.Tag.ReadOnly]]
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codeartifact.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListTagsForResourceResponse
  ) extends zio.aws.codeartifact.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Option[List[zio.aws.codeartifact.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codeartifact.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListTagsForResourceResponse
  ): zio.aws.codeartifact.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
