package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  PolicyDocument,
  PolicyRevision,
  AccountId,
  DomainName
}
import scala.jdk.CollectionConverters._
final case class PutDomainPermissionsPolicyRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    policyRevision: Option[PolicyRevision] = None,
    policyDocument: PolicyDocument
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyRequest = {
    import PutDomainPermissionsPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .optionallyWith(
        policyRevision.map(value =>
          PolicyRevision.unwrap(value): java.lang.String
        )
      )(_.policyRevision)
      .policyDocument(PolicyDocument.unwrap(policyDocument): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.PutDomainPermissionsPolicyRequest.ReadOnly =
    zio.aws.codeartifact.model.PutDomainPermissionsPolicyRequest
      .wrap(buildAwsValue())
}
object PutDomainPermissionsPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.PutDomainPermissionsPolicyRequest =
      zio.aws.codeartifact.model.PutDomainPermissionsPolicyRequest(
        domain,
        domainOwner.map(value => value),
        policyRevision.map(value => value),
        policyDocument
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def policyRevision: Option[PolicyRevision]
    def policyDocument: PolicyDocument
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getPolicyRevision: ZIO[Any, AwsError, PolicyRevision] =
      AwsError.unwrapOptionField("policyRevision", policyRevision)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocument] =
      ZIO.succeed(policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyRequest
  ) extends zio.aws.codeartifact.model.PutDomainPermissionsPolicyRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val policyRevision: Option[PolicyRevision] = scala
      .Option(impl.policyRevision())
      .map(value => zio.aws.codeartifact.model.primitives.PolicyRevision(value))
    override val policyDocument: PolicyDocument =
      zio.aws.codeartifact.model.primitives
        .PolicyDocument(impl.policyDocument())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyRequest
  ): zio.aws.codeartifact.model.PutDomainPermissionsPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
