package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  Timestamp,
  PackageVersion,
  PackageNamespace,
  String255,
  PackageVersionRevision
}
import scala.jdk.CollectionConverters._
final case class PackageVersionDescription(
    format: Option[zio.aws.codeartifact.model.PackageFormat] = None,
    namespace: Option[PackageNamespace] = None,
    packageName: Option[PackageName] = None,
    displayName: Option[String255] = None,
    version: Option[PackageVersion] = None,
    summary: Option[String] = None,
    homePage: Option[String] = None,
    sourceCodeRepository: Option[String] = None,
    publishedTime: Option[Timestamp] = None,
    licenses: Option[Iterable[zio.aws.codeartifact.model.LicenseInfo]] = None,
    revision: Option[PackageVersionRevision] = None,
    status: Option[zio.aws.codeartifact.model.PackageVersionStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PackageVersionDescription = {
    import PackageVersionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PackageVersionDescription
      .builder()
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packageName.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageName)
      .optionallyWith(
        displayName.map(value => String255.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        version.map(value => PackageVersion.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(summary.map(value => value: java.lang.String))(_.summary)
      .optionallyWith(homePage.map(value => value: java.lang.String))(
        _.homePage
      )
      .optionallyWith(
        sourceCodeRepository.map(value => value: java.lang.String)
      )(_.sourceCodeRepository)
      .optionallyWith(
        publishedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.publishedTime)
      .optionallyWith(
        licenses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenses)
      .optionallyWith(
        revision.map(value =>
          PackageVersionRevision.unwrap(value): java.lang.String
        )
      )(_.revision)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.PackageVersionDescription.ReadOnly =
    zio.aws.codeartifact.model.PackageVersionDescription.wrap(buildAwsValue())
}
object PackageVersionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PackageVersionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PackageVersionDescription =
      zio.aws.codeartifact.model.PackageVersionDescription(
        format.map(value => value),
        namespace.map(value => value),
        packageName.map(value => value),
        displayName.map(value => value),
        version.map(value => value),
        summary.map(value => value),
        homePage.map(value => value),
        sourceCodeRepository.map(value => value),
        publishedTime.map(value => value),
        licenses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        revision.map(value => value),
        status.map(value => value)
      )
    def format: Option[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Option[PackageNamespace]
    def packageName: Option[PackageName]
    def displayName: Option[String255]
    def version: Option[PackageVersion]
    def summary: Option[String]
    def homePage: Option[String]
    def sourceCodeRepository: Option[String]
    def publishedTime: Option[Timestamp]
    def licenses: Option[List[zio.aws.codeartifact.model.LicenseInfo.ReadOnly]]
    def revision: Option[PackageVersionRevision]
    def status: Option[zio.aws.codeartifact.model.PackageVersionStatus]
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageName: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageName", packageName)
    def getDisplayName: ZIO[Any, AwsError, String255] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("version", version)
    def getSummary: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("summary", summary)
    def getHomePage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("homePage", homePage)
    def getSourceCodeRepository: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceCodeRepository", sourceCodeRepository)
    def getPublishedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("publishedTime", publishedTime)
    def getLicenses: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.LicenseInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("licenses", licenses)
    def getRevision: ZIO[Any, AwsError, PackageVersionRevision] =
      AwsError.unwrapOptionField("revision", revision)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageVersionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageVersionDescription
  ) extends zio.aws.codeartifact.model.PackageVersionDescription.ReadOnly {
    override val format: Option[zio.aws.codeartifact.model.PackageFormat] =
      scala
        .Option(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Option[PackageNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageName: Option[PackageName] = scala
      .Option(impl.packageName())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val displayName: Option[String255] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.codeartifact.model.primitives.String255(value))
    override val version: Option[PackageVersion] = scala
      .Option(impl.version())
      .map(value => zio.aws.codeartifact.model.primitives.PackageVersion(value))
    override val summary: Option[String] =
      scala.Option(impl.summary()).map(value => value: String)
    override val homePage: Option[String] =
      scala.Option(impl.homePage()).map(value => value: String)
    override val sourceCodeRepository: Option[String] =
      scala.Option(impl.sourceCodeRepository()).map(value => value: String)
    override val publishedTime: Option[Timestamp] = scala
      .Option(impl.publishedTime())
      .map(value => zio.aws.codeartifact.model.primitives.Timestamp(value))
    override val licenses
        : Option[List[zio.aws.codeartifact.model.LicenseInfo.ReadOnly]] = scala
      .Option(impl.licenses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codeartifact.model.LicenseInfo.wrap(item)
        }.toList
      )
    override val revision: Option[PackageVersionRevision] = scala
      .Option(impl.revision())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageVersionRevision(value)
      )
    override val status
        : Option[zio.aws.codeartifact.model.PackageVersionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.codeartifact.model.PackageVersionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageVersionDescription
  ): zio.aws.codeartifact.model.PackageVersionDescription.ReadOnly =
    new Wrapper(impl)
}
