package zio.aws.codeartifact
import zio.aws.codeartifact.model.CreateDomainResponse.ReadOnly
import software.amazon.awssdk.services.codeartifact.paginators.{
  ListRepositoriesInDomainPublisher,
  ListPackageVersionAssetsPublisher,
  ListPackageVersionsPublisher,
  ListDomainsPublisher,
  ListPackagesPublisher,
  ListRepositoriesPublisher
}
import software.amazon.awssdk.services.codeartifact.{
  CodeartifactAsyncClientBuilder,
  CodeartifactAsyncClient
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.codeartifact.model.{
  GetAuthorizationTokenResponse,
  DeleteRepositoryPermissionsPolicyResponse,
  ListPackageVersionsResponse,
  GetAuthorizationTokenRequest,
  DisposePackageVersionsRequest,
  UpdatePackageVersionsStatusResponse,
  AssociateExternalConnectionRequest,
  ListPackagesRequest,
  DeleteRepositoryResponse,
  PackageVersionSummary,
  ListRepositoriesResponse,
  PutRepositoryPermissionsPolicyResponse,
  ListDomainsResponse,
  ListPackageVersionAssetsRequest,
  CreateDomainResponse,
  CreateRepositoryResponse,
  DescribeDomainResponse,
  ListRepositoriesInDomainRequest,
  AssetSummary,
  PutDomainPermissionsPolicyResponse,
  ListRepositoriesInDomainResponse,
  ListPackageVersionDependenciesResponse,
  DisassociateExternalConnectionResponse,
  GetRepositoryEndpointRequest,
  ListTagsForResourceRequest,
  GetPackageVersionAssetResponse,
  CreateRepositoryRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetDomainPermissionsPolicyResponse,
  DeleteDomainPermissionsPolicyResponse,
  DeleteDomainRequest,
  DeleteRepositoryPermissionsPolicyRequest,
  CopyPackageVersionsRequest,
  GetPackageVersionReadmeRequest,
  ListPackageVersionAssetsResponse,
  DisposePackageVersionsResponse,
  DeletePackageVersionsRequest,
  DescribePackageVersionRequest,
  DescribeDomainRequest,
  GetRepositoryEndpointResponse,
  CreateDomainRequest,
  DomainSummary,
  UntagResourceRequest,
  ListRepositoriesRequest,
  ListPackageVersionsRequest,
  DescribeRepositoryRequest,
  GetPackageVersionReadmeResponse,
  RepositorySummary,
  DeletePackageVersionsResponse,
  DisassociateExternalConnectionRequest,
  PutDomainPermissionsPolicyRequest,
  DeleteDomainPermissionsPolicyRequest,
  ListPackageVersionDependenciesRequest,
  DescribeRepositoryResponse,
  DeleteRepositoryRequest,
  TagResourceResponse,
  DescribePackageVersionResponse,
  GetRepositoryPermissionsPolicyResponse,
  PackageSummary,
  PutRepositoryPermissionsPolicyRequest,
  GetDomainPermissionsPolicyRequest,
  UpdatePackageVersionsStatusRequest,
  UpdateRepositoryRequest,
  ListPackagesResponse,
  ListDomainsRequest,
  TagResourceRequest,
  AssociateExternalConnectionResponse,
  DeleteDomainResponse,
  GetRepositoryPermissionsPolicyRequest,
  UpdateRepositoryResponse,
  CopyPackageVersionsResponse,
  GetPackageVersionAssetRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Task, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Codeartifact extends AspectSupport[Codeartifact] {
  val api: CodeartifactAsyncClient
  def getAuthorizationToken(
      request: zio.aws.codeartifact.model.GetAuthorizationTokenRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.GetAuthorizationTokenResponse.ReadOnly
  ]
  def listPackageVersionDependencies(
      request: zio.aws.codeartifact.model.ListPackageVersionDependenciesRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse.ReadOnly
  ]
  def getPackageVersionAsset(
      request: zio.aws.codeartifact.model.GetPackageVersionAssetRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.codeartifact.model.GetPackageVersionAssetResponse.ReadOnly,
    Byte
  ]]
  def describeDomain(
      request: zio.aws.codeartifact.model.DescribeDomainRequest
  ): IO[AwsError, zio.aws.codeartifact.model.DescribeDomainResponse.ReadOnly]
  def deletePackageVersions(
      request: zio.aws.codeartifact.model.DeletePackageVersionsRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.DeletePackageVersionsResponse.ReadOnly
  ]
  def getRepositoryEndpoint(
      request: zio.aws.codeartifact.model.GetRepositoryEndpointRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.GetRepositoryEndpointResponse.ReadOnly
  ]
  def deleteRepository(
      request: zio.aws.codeartifact.model.DeleteRepositoryRequest
  ): IO[AwsError, zio.aws.codeartifact.model.DeleteRepositoryResponse.ReadOnly]
  def listPackageVersionAssets(
      request: zio.aws.codeartifact.model.ListPackageVersionAssetsRequest
  ): ZStream[Any, AwsError, zio.aws.codeartifact.model.AssetSummary.ReadOnly]
  def listPackageVersionAssetsPaginated(
      request: zio.aws.codeartifact.model.ListPackageVersionAssetsRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.ListPackageVersionAssetsResponse.ReadOnly
  ]
  def listDomains(
      request: zio.aws.codeartifact.model.ListDomainsRequest
  ): ZStream[Any, AwsError, zio.aws.codeartifact.model.DomainSummary.ReadOnly]
  def listDomainsPaginated(
      request: zio.aws.codeartifact.model.ListDomainsRequest
  ): IO[AwsError, zio.aws.codeartifact.model.ListDomainsResponse.ReadOnly]
  def disassociateExternalConnection(
      request: zio.aws.codeartifact.model.DisassociateExternalConnectionRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.DisassociateExternalConnectionResponse.ReadOnly
  ]
  def updatePackageVersionsStatus(
      request: zio.aws.codeartifact.model.UpdatePackageVersionsStatusRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.UpdatePackageVersionsStatusResponse.ReadOnly
  ]
  def associateExternalConnection(
      request: zio.aws.codeartifact.model.AssociateExternalConnectionRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.AssociateExternalConnectionResponse.ReadOnly
  ]
  def updateRepository(
      request: zio.aws.codeartifact.model.UpdateRepositoryRequest
  ): IO[AwsError, zio.aws.codeartifact.model.UpdateRepositoryResponse.ReadOnly]
  def createRepository(
      request: zio.aws.codeartifact.model.CreateRepositoryRequest
  ): IO[AwsError, zio.aws.codeartifact.model.CreateRepositoryResponse.ReadOnly]
  def deleteRepositoryPermissionsPolicy(
      request: zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse.ReadOnly
  ]
  def getPackageVersionReadme(
      request: zio.aws.codeartifact.model.GetPackageVersionReadmeRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.GetPackageVersionReadmeResponse.ReadOnly
  ]
  def createDomain(
      request: zio.aws.codeartifact.model.CreateDomainRequest
  ): IO[AwsError, ReadOnly]
  def describeRepository(
      request: zio.aws.codeartifact.model.DescribeRepositoryRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.DescribeRepositoryResponse.ReadOnly
  ]
  def getDomainPermissionsPolicy(
      request: zio.aws.codeartifact.model.GetDomainPermissionsPolicyRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.GetDomainPermissionsPolicyResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.codeartifact.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.codeartifact.model.UntagResourceResponse.ReadOnly]
  def listPackageVersions(
      request: zio.aws.codeartifact.model.ListPackageVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly
  ]
  def listPackageVersionsPaginated(
      request: zio.aws.codeartifact.model.ListPackageVersionsRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.ListPackageVersionsResponse.ReadOnly
  ]
  def deleteDomainPermissionsPolicy(
      request: zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyResponse.ReadOnly
  ]
  def copyPackageVersions(
      request: zio.aws.codeartifact.model.CopyPackageVersionsRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.CopyPackageVersionsResponse.ReadOnly
  ]
  def putDomainPermissionsPolicy(
      request: zio.aws.codeartifact.model.PutDomainPermissionsPolicyRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.PutDomainPermissionsPolicyResponse.ReadOnly
  ]
  def listRepositories(
      request: zio.aws.codeartifact.model.ListRepositoriesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.codeartifact.model.RepositorySummary.ReadOnly
  ]
  def listRepositoriesPaginated(
      request: zio.aws.codeartifact.model.ListRepositoriesRequest
  ): IO[AwsError, zio.aws.codeartifact.model.ListRepositoriesResponse.ReadOnly]
  def getRepositoryPermissionsPolicy(
      request: zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyResponse.ReadOnly
  ]
  def describePackageVersion(
      request: zio.aws.codeartifact.model.DescribePackageVersionRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.DescribePackageVersionResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.codeartifact.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.ListTagsForResourceResponse.ReadOnly
  ]
  def disposePackageVersions(
      request: zio.aws.codeartifact.model.DisposePackageVersionsRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.DisposePackageVersionsResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.codeartifact.model.TagResourceRequest
  ): IO[AwsError, zio.aws.codeartifact.model.TagResourceResponse.ReadOnly]
  def deleteDomain(
      request: zio.aws.codeartifact.model.DeleteDomainRequest
  ): IO[AwsError, zio.aws.codeartifact.model.DeleteDomainResponse.ReadOnly]
  def listRepositoriesInDomain(
      request: zio.aws.codeartifact.model.ListRepositoriesInDomainRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.codeartifact.model.RepositorySummary.ReadOnly
  ]
  def listRepositoriesInDomainPaginated(
      request: zio.aws.codeartifact.model.ListRepositoriesInDomainRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.ListRepositoriesInDomainResponse.ReadOnly
  ]
  def putRepositoryPermissionsPolicy(
      request: zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyRequest
  ): IO[
    AwsError,
    zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyResponse.ReadOnly
  ]
  def listPackages(
      request: zio.aws.codeartifact.model.ListPackagesRequest
  ): ZStream[Any, AwsError, zio.aws.codeartifact.model.PackageSummary.ReadOnly]
  def listPackagesPaginated(
      request: zio.aws.codeartifact.model.ListPackagesRequest
  ): IO[AwsError, zio.aws.codeartifact.model.ListPackagesResponse.ReadOnly]
}
object Codeartifact {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Codeartifact] = customized(
    identity
  )
  def customized(
      customization: CodeartifactAsyncClientBuilder => CodeartifactAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Codeartifact] = managed(
    customization
  ).toLayer
  def managed(
      customization: CodeartifactAsyncClientBuilder => CodeartifactAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Codeartifact] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CodeartifactAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CodeartifactAsyncClient, CodeartifactAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        CodeartifactAsyncClient,
        CodeartifactAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new CodeartifactImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CodeartifactImpl[R](
      override val api: CodeartifactAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Codeartifact
      with AwsServiceBase[R] {
    override val serviceName: String = "Codeartifact"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CodeartifactImpl[R1] = new CodeartifactImpl(api, newAspect, r)
    def getAuthorizationToken(
        request: zio.aws.codeartifact.model.GetAuthorizationTokenRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.GetAuthorizationTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAuthorizationTokenRequest,
      GetAuthorizationTokenResponse
    ]("getAuthorizationToken", api.getAuthorizationToken)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.GetAuthorizationTokenResponse.wrap)
      .provideEnvironment(r)
    def listPackageVersionDependencies(
        request: zio.aws.codeartifact.model.ListPackageVersionDependenciesRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListPackageVersionDependenciesRequest,
      ListPackageVersionDependenciesResponse
    ]("listPackageVersionDependencies", api.listPackageVersionDependencies)(
      request.buildAwsValue()
    ).map(
      zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse.wrap
    ).provideEnvironment(r)
    def getPackageVersionAsset(
        request: zio.aws.codeartifact.model.GetPackageVersionAssetRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.codeartifact.model.GetPackageVersionAssetResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      GetPackageVersionAssetRequest,
      GetPackageVersionAssetResponse
    ](
      "getPackageVersionAsset",
      api.getPackageVersionAsset[Task[
        StreamingOutputResult[R, GetPackageVersionAssetResponse, Byte]
      ]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(
          zio.aws.codeartifact.model.GetPackageVersionAssetResponse.wrap
        ).provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeDomain(
        request: zio.aws.codeartifact.model.DescribeDomainRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.DescribeDomainResponse.ReadOnly
    ] = asyncRequestResponse[DescribeDomainRequest, DescribeDomainResponse](
      "describeDomain",
      api.describeDomain
    )(request.buildAwsValue())
      .map(zio.aws.codeartifact.model.DescribeDomainResponse.wrap)
      .provideEnvironment(r)
    def deletePackageVersions(
        request: zio.aws.codeartifact.model.DeletePackageVersionsRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.DeletePackageVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DeletePackageVersionsRequest,
      DeletePackageVersionsResponse
    ]("deletePackageVersions", api.deletePackageVersions)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.DeletePackageVersionsResponse.wrap)
      .provideEnvironment(r)
    def getRepositoryEndpoint(
        request: zio.aws.codeartifact.model.GetRepositoryEndpointRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.GetRepositoryEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRepositoryEndpointRequest,
      GetRepositoryEndpointResponse
    ]("getRepositoryEndpoint", api.getRepositoryEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.GetRepositoryEndpointResponse.wrap)
      .provideEnvironment(r)
    def deleteRepository(
        request: zio.aws.codeartifact.model.DeleteRepositoryRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.DeleteRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[DeleteRepositoryRequest, DeleteRepositoryResponse](
      "deleteRepository",
      api.deleteRepository
    )(request.buildAwsValue())
      .map(zio.aws.codeartifact.model.DeleteRepositoryResponse.wrap)
      .provideEnvironment(r)
    def listPackageVersionAssets(
        request: zio.aws.codeartifact.model.ListPackageVersionAssetsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codeartifact.model.AssetSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListPackageVersionAssetsRequest,
      AssetSummary,
      ListPackageVersionAssetsPublisher
    ](
      "listPackageVersionAssets",
      api.listPackageVersionAssetsPaginator,
      _.assets()
    )(request.buildAwsValue())
      .map(item => zio.aws.codeartifact.model.AssetSummary.wrap(item))
      .provideEnvironment(r)
    def listPackageVersionAssetsPaginated(
        request: zio.aws.codeartifact.model.ListPackageVersionAssetsRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.ListPackageVersionAssetsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListPackageVersionAssetsRequest,
      ListPackageVersionAssetsResponse
    ]("listPackageVersionAssets", api.listPackageVersionAssets)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.ListPackageVersionAssetsResponse.wrap)
      .provideEnvironment(r)
    def listDomains(
        request: zio.aws.codeartifact.model.ListDomainsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codeartifact.model.DomainSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListDomainsRequest,
      DomainSummary,
      ListDomainsPublisher
    ]("listDomains", api.listDomainsPaginator, _.domains())(
      request.buildAwsValue()
    ).map(item => zio.aws.codeartifact.model.DomainSummary.wrap(item))
      .provideEnvironment(r)
    def listDomainsPaginated(
        request: zio.aws.codeartifact.model.ListDomainsRequest
    ): IO[AwsError, zio.aws.codeartifact.model.ListDomainsResponse.ReadOnly] =
      asyncRequestResponse[ListDomainsRequest, ListDomainsResponse](
        "listDomains",
        api.listDomains
      )(request.buildAwsValue())
        .map(zio.aws.codeartifact.model.ListDomainsResponse.wrap)
        .provideEnvironment(r)
    def disassociateExternalConnection(
        request: zio.aws.codeartifact.model.DisassociateExternalConnectionRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.DisassociateExternalConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateExternalConnectionRequest,
      DisassociateExternalConnectionResponse
    ]("disassociateExternalConnection", api.disassociateExternalConnection)(
      request.buildAwsValue()
    ).map(
      zio.aws.codeartifact.model.DisassociateExternalConnectionResponse.wrap
    ).provideEnvironment(r)
    def updatePackageVersionsStatus(
        request: zio.aws.codeartifact.model.UpdatePackageVersionsStatusRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.UpdatePackageVersionsStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdatePackageVersionsStatusRequest,
      UpdatePackageVersionsStatusResponse
    ]("updatePackageVersionsStatus", api.updatePackageVersionsStatus)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.UpdatePackageVersionsStatusResponse.wrap)
      .provideEnvironment(r)
    def associateExternalConnection(
        request: zio.aws.codeartifact.model.AssociateExternalConnectionRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.AssociateExternalConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateExternalConnectionRequest,
      AssociateExternalConnectionResponse
    ]("associateExternalConnection", api.associateExternalConnection)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.AssociateExternalConnectionResponse.wrap)
      .provideEnvironment(r)
    def updateRepository(
        request: zio.aws.codeartifact.model.UpdateRepositoryRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.UpdateRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[UpdateRepositoryRequest, UpdateRepositoryResponse](
      "updateRepository",
      api.updateRepository
    )(request.buildAwsValue())
      .map(zio.aws.codeartifact.model.UpdateRepositoryResponse.wrap)
      .provideEnvironment(r)
    def createRepository(
        request: zio.aws.codeartifact.model.CreateRepositoryRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.CreateRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[CreateRepositoryRequest, CreateRepositoryResponse](
      "createRepository",
      api.createRepository
    )(request.buildAwsValue())
      .map(zio.aws.codeartifact.model.CreateRepositoryResponse.wrap)
      .provideEnvironment(r)
    def deleteRepositoryPermissionsPolicy(
        request: zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteRepositoryPermissionsPolicyRequest,
      DeleteRepositoryPermissionsPolicyResponse
    ](
      "deleteRepositoryPermissionsPolicy",
      api.deleteRepositoryPermissionsPolicy
    )(request.buildAwsValue())
      .map(
        zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse.wrap
      )
      .provideEnvironment(r)
    def getPackageVersionReadme(
        request: zio.aws.codeartifact.model.GetPackageVersionReadmeRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.GetPackageVersionReadmeResponse.ReadOnly
    ] = asyncRequestResponse[
      GetPackageVersionReadmeRequest,
      GetPackageVersionReadmeResponse
    ]("getPackageVersionReadme", api.getPackageVersionReadme)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.GetPackageVersionReadmeResponse.wrap)
      .provideEnvironment(r)
    def createDomain(
        request: zio.aws.codeartifact.model.CreateDomainRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[CreateDomainRequest, CreateDomainResponse](
        "createDomain",
        api.createDomain
      )(request.buildAwsValue())
        .map(zio.aws.codeartifact.model.CreateDomainResponse.wrap)
        .provideEnvironment(r)
    def describeRepository(
        request: zio.aws.codeartifact.model.DescribeRepositoryRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.DescribeRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRepositoryRequest,
      DescribeRepositoryResponse
    ]("describeRepository", api.describeRepository)(request.buildAwsValue())
      .map(zio.aws.codeartifact.model.DescribeRepositoryResponse.wrap)
      .provideEnvironment(r)
    def getDomainPermissionsPolicy(
        request: zio.aws.codeartifact.model.GetDomainPermissionsPolicyRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.GetDomainPermissionsPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDomainPermissionsPolicyRequest,
      GetDomainPermissionsPolicyResponse
    ]("getDomainPermissionsPolicy", api.getDomainPermissionsPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.GetDomainPermissionsPolicyResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.codeartifact.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.codeartifact.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.codeartifact.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listPackageVersions(
        request: zio.aws.codeartifact.model.ListPackageVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListPackageVersionsRequest,
      PackageVersionSummary,
      ListPackageVersionsPublisher
    ]("listPackageVersions", api.listPackageVersionsPaginator, _.versions())(
      request.buildAwsValue()
    ).map(item => zio.aws.codeartifact.model.PackageVersionSummary.wrap(item))
      .provideEnvironment(r)
    def listPackageVersionsPaginated(
        request: zio.aws.codeartifact.model.ListPackageVersionsRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.ListPackageVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListPackageVersionsRequest,
      ListPackageVersionsResponse
    ]("listPackageVersions", api.listPackageVersions)(request.buildAwsValue())
      .map(zio.aws.codeartifact.model.ListPackageVersionsResponse.wrap)
      .provideEnvironment(r)
    def deleteDomainPermissionsPolicy(
        request: zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDomainPermissionsPolicyRequest,
      DeleteDomainPermissionsPolicyResponse
    ]("deleteDomainPermissionsPolicy", api.deleteDomainPermissionsPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyResponse.wrap)
      .provideEnvironment(r)
    def copyPackageVersions(
        request: zio.aws.codeartifact.model.CopyPackageVersionsRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.CopyPackageVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      CopyPackageVersionsRequest,
      CopyPackageVersionsResponse
    ]("copyPackageVersions", api.copyPackageVersions)(request.buildAwsValue())
      .map(zio.aws.codeartifact.model.CopyPackageVersionsResponse.wrap)
      .provideEnvironment(r)
    def putDomainPermissionsPolicy(
        request: zio.aws.codeartifact.model.PutDomainPermissionsPolicyRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.PutDomainPermissionsPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      PutDomainPermissionsPolicyRequest,
      PutDomainPermissionsPolicyResponse
    ]("putDomainPermissionsPolicy", api.putDomainPermissionsPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.PutDomainPermissionsPolicyResponse.wrap)
      .provideEnvironment(r)
    def listRepositories(
        request: zio.aws.codeartifact.model.ListRepositoriesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codeartifact.model.RepositorySummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListRepositoriesRequest,
      RepositorySummary,
      ListRepositoriesPublisher
    ]("listRepositories", api.listRepositoriesPaginator, _.repositories())(
      request.buildAwsValue()
    ).map(item => zio.aws.codeartifact.model.RepositorySummary.wrap(item))
      .provideEnvironment(r)
    def listRepositoriesPaginated(
        request: zio.aws.codeartifact.model.ListRepositoriesRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.ListRepositoriesResponse.ReadOnly
    ] = asyncRequestResponse[ListRepositoriesRequest, ListRepositoriesResponse](
      "listRepositories",
      api.listRepositories
    )(request.buildAwsValue())
      .map(zio.aws.codeartifact.model.ListRepositoriesResponse.wrap)
      .provideEnvironment(r)
    def getRepositoryPermissionsPolicy(
        request: zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRepositoryPermissionsPolicyRequest,
      GetRepositoryPermissionsPolicyResponse
    ]("getRepositoryPermissionsPolicy", api.getRepositoryPermissionsPolicy)(
      request.buildAwsValue()
    ).map(
      zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyResponse.wrap
    ).provideEnvironment(r)
    def describePackageVersion(
        request: zio.aws.codeartifact.model.DescribePackageVersionRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.DescribePackageVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePackageVersionRequest,
      DescribePackageVersionResponse
    ]("describePackageVersion", api.describePackageVersion)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.DescribePackageVersionResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.codeartifact.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.codeartifact.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def disposePackageVersions(
        request: zio.aws.codeartifact.model.DisposePackageVersionsRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.DisposePackageVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DisposePackageVersionsRequest,
      DisposePackageVersionsResponse
    ]("disposePackageVersions", api.disposePackageVersions)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.DisposePackageVersionsResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.codeartifact.model.TagResourceRequest
    ): IO[AwsError, zio.aws.codeartifact.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.codeartifact.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteDomain(
        request: zio.aws.codeartifact.model.DeleteDomainRequest
    ): IO[AwsError, zio.aws.codeartifact.model.DeleteDomainResponse.ReadOnly] =
      asyncRequestResponse[DeleteDomainRequest, DeleteDomainResponse](
        "deleteDomain",
        api.deleteDomain
      )(request.buildAwsValue())
        .map(zio.aws.codeartifact.model.DeleteDomainResponse.wrap)
        .provideEnvironment(r)
    def listRepositoriesInDomain(
        request: zio.aws.codeartifact.model.ListRepositoriesInDomainRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codeartifact.model.RepositorySummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListRepositoriesInDomainRequest,
      RepositorySummary,
      ListRepositoriesInDomainPublisher
    ](
      "listRepositoriesInDomain",
      api.listRepositoriesInDomainPaginator,
      _.repositories()
    )(request.buildAwsValue())
      .map(item => zio.aws.codeartifact.model.RepositorySummary.wrap(item))
      .provideEnvironment(r)
    def listRepositoriesInDomainPaginated(
        request: zio.aws.codeartifact.model.ListRepositoriesInDomainRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.ListRepositoriesInDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      ListRepositoriesInDomainRequest,
      ListRepositoriesInDomainResponse
    ]("listRepositoriesInDomain", api.listRepositoriesInDomain)(
      request.buildAwsValue()
    ).map(zio.aws.codeartifact.model.ListRepositoriesInDomainResponse.wrap)
      .provideEnvironment(r)
    def putRepositoryPermissionsPolicy(
        request: zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyRequest
    ): IO[
      AwsError,
      zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      PutRepositoryPermissionsPolicyRequest,
      PutRepositoryPermissionsPolicyResponse
    ]("putRepositoryPermissionsPolicy", api.putRepositoryPermissionsPolicy)(
      request.buildAwsValue()
    ).map(
      zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyResponse.wrap
    ).provideEnvironment(r)
    def listPackages(
        request: zio.aws.codeartifact.model.ListPackagesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codeartifact.model.PackageSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListPackagesRequest,
      PackageSummary,
      ListPackagesPublisher
    ]("listPackages", api.listPackagesPaginator, _.packages())(
      request.buildAwsValue()
    ).map(item => zio.aws.codeartifact.model.PackageSummary.wrap(item))
      .provideEnvironment(r)
    def listPackagesPaginated(
        request: zio.aws.codeartifact.model.ListPackagesRequest
    ): IO[AwsError, zio.aws.codeartifact.model.ListPackagesResponse.ReadOnly] =
      asyncRequestResponse[ListPackagesRequest, ListPackagesResponse](
        "listPackages",
        api.listPackages
      )(request.buildAwsValue())
        .map(zio.aws.codeartifact.model.ListPackagesResponse.wrap)
        .provideEnvironment(r)
  }
  def getAuthorizationToken(
      request: zio.aws.codeartifact.model.GetAuthorizationTokenRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.GetAuthorizationTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAuthorizationToken(request))
  def listPackageVersionDependencies(
      request: zio.aws.codeartifact.model.ListPackageVersionDependenciesRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.ListPackageVersionDependenciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPackageVersionDependencies(request))
  def getPackageVersionAsset(
      request: zio.aws.codeartifact.model.GetPackageVersionAssetRequest
  ): ZIO[zio.aws.codeartifact.Codeartifact, AwsError, StreamingOutputResult[
    Any,
    zio.aws.codeartifact.model.GetPackageVersionAssetResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.getPackageVersionAsset(request))
  def describeDomain(
      request: zio.aws.codeartifact.model.DescribeDomainRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.DescribeDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDomain(request))
  def deletePackageVersions(
      request: zio.aws.codeartifact.model.DeletePackageVersionsRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.DeletePackageVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePackageVersions(request))
  def getRepositoryEndpoint(
      request: zio.aws.codeartifact.model.GetRepositoryEndpointRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.GetRepositoryEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRepositoryEndpoint(request))
  def deleteRepository(
      request: zio.aws.codeartifact.model.DeleteRepositoryRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.DeleteRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRepository(request))
  def listPackageVersionAssets(
      request: zio.aws.codeartifact.model.ListPackageVersionAssetsRequest
  ): ZStream[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.AssetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPackageVersionAssets(request))
  def listPackageVersionAssetsPaginated(
      request: zio.aws.codeartifact.model.ListPackageVersionAssetsRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.ListPackageVersionAssetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPackageVersionAssetsPaginated(request))
  def listDomains(
      request: zio.aws.codeartifact.model.ListDomainsRequest
  ): ZStream[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.DomainSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDomains(request))
  def listDomainsPaginated(
      request: zio.aws.codeartifact.model.ListDomainsRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.ListDomainsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomainsPaginated(request))
  def disassociateExternalConnection(
      request: zio.aws.codeartifact.model.DisassociateExternalConnectionRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.DisassociateExternalConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateExternalConnection(request))
  def updatePackageVersionsStatus(
      request: zio.aws.codeartifact.model.UpdatePackageVersionsStatusRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.UpdatePackageVersionsStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePackageVersionsStatus(request))
  def associateExternalConnection(
      request: zio.aws.codeartifact.model.AssociateExternalConnectionRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.AssociateExternalConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateExternalConnection(request))
  def updateRepository(
      request: zio.aws.codeartifact.model.UpdateRepositoryRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.UpdateRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRepository(request))
  def createRepository(
      request: zio.aws.codeartifact.model.CreateRepositoryRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.CreateRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRepository(request))
  def deleteRepositoryPermissionsPolicy(
      request: zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRepositoryPermissionsPolicy(request))
  def getPackageVersionReadme(
      request: zio.aws.codeartifact.model.GetPackageVersionReadmeRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.GetPackageVersionReadmeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPackageVersionReadme(request))
  def createDomain(
      request: zio.aws.codeartifact.model.CreateDomainRequest
  ): ZIO[zio.aws.codeartifact.Codeartifact, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createDomain(request))
  def describeRepository(
      request: zio.aws.codeartifact.model.DescribeRepositoryRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.DescribeRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRepository(request))
  def getDomainPermissionsPolicy(
      request: zio.aws.codeartifact.model.GetDomainPermissionsPolicyRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.GetDomainPermissionsPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomainPermissionsPolicy(request))
  def untagResource(
      request: zio.aws.codeartifact.model.UntagResourceRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listPackageVersions(
      request: zio.aws.codeartifact.model.ListPackageVersionsRequest
  ): ZStream[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPackageVersions(request))
  def listPackageVersionsPaginated(
      request: zio.aws.codeartifact.model.ListPackageVersionsRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.ListPackageVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPackageVersionsPaginated(request))
  def deleteDomainPermissionsPolicy(
      request: zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDomainPermissionsPolicy(request))
  def copyPackageVersions(
      request: zio.aws.codeartifact.model.CopyPackageVersionsRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.CopyPackageVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyPackageVersions(request))
  def putDomainPermissionsPolicy(
      request: zio.aws.codeartifact.model.PutDomainPermissionsPolicyRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.PutDomainPermissionsPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putDomainPermissionsPolicy(request))
  def listRepositories(
      request: zio.aws.codeartifact.model.ListRepositoriesRequest
  ): ZStream[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.RepositorySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRepositories(request))
  def listRepositoriesPaginated(
      request: zio.aws.codeartifact.model.ListRepositoriesRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.ListRepositoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRepositoriesPaginated(request))
  def getRepositoryPermissionsPolicy(
      request: zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRepositoryPermissionsPolicy(request))
  def describePackageVersion(
      request: zio.aws.codeartifact.model.DescribePackageVersionRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.DescribePackageVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePackageVersion(request))
  def listTagsForResource(
      request: zio.aws.codeartifact.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def disposePackageVersions(
      request: zio.aws.codeartifact.model.DisposePackageVersionsRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.DisposePackageVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disposePackageVersions(request))
  def tagResource(request: zio.aws.codeartifact.model.TagResourceRequest): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteDomain(
      request: zio.aws.codeartifact.model.DeleteDomainRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.DeleteDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDomain(request))
  def listRepositoriesInDomain(
      request: zio.aws.codeartifact.model.ListRepositoriesInDomainRequest
  ): ZStream[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.RepositorySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRepositoriesInDomain(request))
  def listRepositoriesInDomainPaginated(
      request: zio.aws.codeartifact.model.ListRepositoriesInDomainRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.ListRepositoriesInDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRepositoriesInDomainPaginated(request))
  def putRepositoryPermissionsPolicy(
      request: zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRepositoryPermissionsPolicy(request))
  def listPackages(
      request: zio.aws.codeartifact.model.ListPackagesRequest
  ): ZStream[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.PackageSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPackages(request))
  def listPackagesPaginated(
      request: zio.aws.codeartifact.model.ListPackagesRequest
  ): ZIO[
    zio.aws.codeartifact.Codeartifact,
    AwsError,
    zio.aws.codeartifact.model.ListPackagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPackagesPaginated(request))
}
